% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkm.R
\docType{class}
\name{mkm-class}
\alias{mkm-class}
\alias{show,mkm-method}
\title{A S4 class of multiple Kriging models}
\usage{
\S4method{show}{mkm}(object)
}
\arguments{
\item{object}{A \code{mkm} object.}
}
\description{
A S4 class of multiple Kriging models
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Custom print for \code{mkm} objects
}}
\section{Slots}{

\describe{
\item{\code{km}}{A list of \code{\link{km}} objectives.}

\item{\code{objective}}{A Numeric vector representing the index of the objective
models in \code{km}.}

\item{\code{design}}{Numeric data.frame of the designs (decision space).}

\item{\code{d,n,m,j}}{Numeric values for the number of dimensions, designs,
objectives and constraints, respectively.}

\item{\code{response}}{Numeric data.frame of the observed responses (objectives and
constraints) at each design point.}

\item{\code{feasible}}{Logical vector stating which designs are feasible.}

\item{\code{control}}{A list of controls for function backtracking, this list
contains all the input parameters that are passed to the \code{\link{km}}
function.}
}}

