% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/OPC3d.R
\name{OPC3d}
\alias{OPC3d}
\title{Plot results of OPC analysis of a surface}
\usage{
OPC3d(OPC_Output_Object, fieldofview = 0, legend = TRUE, colors = hsv(h =
  (seq(10, 290, 35)/360), s = 0.8, v = 0.9))
}
\arguments{
\item{OPC_Output_Object}{An object that stores the output of
the \code{OPC} function}

\item{fieldofview}{Passes an argument to \code{par3d} changing the
field of view in dregrees of the resulting rgl window}

\item{legend}{Logical indicating whether or not a legend should
be displayed}

\item{colors}{Allows the user to change the colors filled in for
each directional bin}
}
\description{
A function that produces a three-dimensional rendering of face
orientation on a surface. The \code{OPC} function will identify the
orientations of mesh faces and assign them to patches. It must be
performed prior to using the \code{OPC3d} function.
}
\details{
This function will assign a uniform color to all faces on the mesh
surface that share one of the 8 orientations identified by the \code{OPC} function. The
function returns a colored \code{shade3d} of the mesh so that patches can be visually
inspected. Future versions will include the option to black out patches not
included in the orientation patch count.

\code{fieldofview} is set to a default of 0, which is an isometric projection. Increasing it
alters the degree of parallax in the perspective view, up to a maximum of 179
degrees.
\code{colors} will support any vector of 8 colors, in any coloration scheme. Default
draws from the HSV color space to evenly space color information, however user
can supply a list of RGB values, character strings, or integers in place.
}

