% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_sensible_connections}
\alias{check_sensible_connections}
\title{Check connection and layer data}
\usage{
check_sensible_connections(connection, layers)
}
\arguments{
\item{connection}{Connection to check. Created by \code{\link{make_connection}}}

\item{layers}{List of layers to check. Individual layers are created by
\code{\link{make_layer}} and need to be wrapped in a list.}
}
\value{
Character string vector containing error messages.
}
\description{
(INTERNAL) Checks if the connection defined in 'connection' makes sense in
context of the defined layers.
}
\examples{
data(mrna_data)
mrna_layer = make_layer(name="mrna",
mrna_data$group1$data, mrna_data$group2$data,
mrna_data$group1$identifiers,
mrna_data$group2$identifiers)
data(protein_data)
protein_layer = make_layer(name="protein",
protein_data$group1$data,
protein_data$group2$data,
protein_data$group1$identifiers,
protein_data$group2$identifiers)
con = make_connection("mrna", "protein", connect_on="gene_name")
return_errors(check_sensible_connections(con, layers=list(mrna_layer, protein_layer)))

}
