% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoRes.R
\name{pseudoRes}
\alias{pseudoRes}
\title{Pseudo-residuals}
\usage{
pseudoRes(m, ncores = 1)
}
\arguments{
\item{m}{A \code{\link{momentuHMM}}, \code{\link{miHMM}}, or \code{\link{miSum}} object. Alternatively, \code{m} can also be a list of \code{\link{momentuHMM}} objects.}

\item{ncores}{number of cores to use for parallel processing}
}
\value{
If \code{m} is a \code{\link{momentuHMM}}, \code{\link{miHMM}}, or \code{\link{miSum}} object, a list of pseudo-residuals for each data stream (e.g., 'stepRes', 'angleRes') is returned. 
If \code{m} is a list of \code{\link{momentuHMM}} objects, then a list of length \code{length(m)} is returned where each element is a list of pseudo-residuals for each data stream.
}
\description{
The pseudo-residuals of momentuHMM models, as described in Zucchini and McDonad (2009).
}
\details{
If some turning angles in the data are equal to pi, the corresponding pseudo-residuals
will not be included. Indeed, given that the turning angles are defined on (-pi,pi], an angle of pi
results in a pseudo-residual of +Inf (check Section 6.2 of reference for more information on the
computation of pseudo-residuals).

A continuity adjustment (adapted from Harte 2017) is made for discrete probability distributions. When
the data are near the boundary (e.g. 0 for ``pois''; 0 and 1 for ``bern''), then the pseudo residuals can
be a poor indicator of lack of fit.

For multiple imputation analyses, if \code{m} is a \code{\link{miHMM}} object or a list of \code{\link{momentuHMM}} objects, then
the pseudo-residuals are individually calculated for each model fit. Note that pseudo-residuals for \code{\link{miSum}} objects (as returned by \code{\link{MIpool}}) are based on pooled parameter 
estimates and the means of the data values across all imputations (and therefore may not be particularly meaningful).
}
\examples{
# m is a momentuHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m
res <- pseudoRes(m)
qqnorm(res$stepRes)
qqnorm(res$angleRes)

}
\references{
Harte, D. 2017. HiddenMarkov: Hidden Markov Models. R package version 1.8-8.

Zucchini, W. and MacDonald, I.L. 2009.
Hidden Markov Models for Time Series: An Introduction Using R.
Chapman & Hall (London).
}
