/*
 * Copyright 2013 MongoDB, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MONGOC_DATABASE_PRIVATE_H
#define MONGOC_DATABASE_PRIVATE_H

#if !defined (MONGOC_I_AM_A_DRIVER) && !defined (MONGOC_COMPILATION)
#error "Only <mongoc.h> can be included directly."
#endif

#include <bson.h>

#include "mongoc-client.h"
#include "mongoc-read-prefs.h"
#include "mongoc-write-concern.h"


BSON_BEGIN_DECLS


struct _mongoc_database_t
{
   mongoc_client_t        *client;
   char                    name [128];
   mongoc_write_concern_t *write_concern;
   mongoc_read_prefs_t    *read_prefs;
};


mongoc_database_t *_mongoc_database_new                         (mongoc_client_t              *client,
                                                                 const char                   *name,
                                                                 const mongoc_read_prefs_t    *read_prefs,
                                                                 const mongoc_write_concern_t *write_concern);
mongoc_cursor_t   *_mongoc_database_find_collections_legacy     (mongoc_database_t            *database,
                                                                 const bson_t                 *filter,
                                                                 bson_error_t                 *error);


BSON_END_DECLS


#endif /* MONGOC_DATABASE_PRIVATE_H */
