% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotLM.R
\name{plotLM}
\alias{plotLM}
\title{Scatter plot of Generalized Procrustes Analysis (GPA) coordinates of anchor landmarks}
\usage{
plotLM(x, tit = "", pointscale = 1, axispointscale = 1, meansize = 1,
  polygon.outline = FALSE, xbound = NULL, ybound = NULL,
  pch.suppress = FALSE)
}
\arguments{
\item{x}{an array containing GPA coordinate data of anchor landmarks}

\item{tit}{title of the plot}

\item{pointscale}{a numeric constant for controlling the symbol size for observations}

\item{axispointscale}{a numeric constant for controlling the font size of labels of values on the xy axes}

\item{meansize}{a constant for controlling the symbol size of the mean coordinates}

\item{polygon.outline}{if TRUE, a wireframe plot connecting all adjacent landmarks is made}

\item{xbound}{a numeric vector specifying the range of x values for the plot}

\item{ybound}{a numeric vector specifying the range of y values for the plot}

\item{pch.suppress}{if TRUE, only the mean coordinates of the landmarks are plotted}
}
\description{
This function generates a scatter plot of GPA coordinates of anchor landmarks, with the option of making a
wireframe plot by joining mean GPA coordinates of adjacent landmarks.
}
\details{
The resulting scatter plot is an important graphical sanity check for potential problems after performing GPA.
}
\examples{
data(liewi_gpa)

nice_title <- expression(paste("Dorsal anchor ", italic(L.liewi)))
plotLM(liewi_gpa, tit=nice_title, pointscale=0.8, axispointscale=0.8,
meansize=1.2, polygon.outline=TRUE,c(-.6,.6),c(-.6,.6) )
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\references{
Khang TF, Soo OYM, Tan WB, Lim LHS. (2015). Monogenean anchor morphometry: systematic value, phylogenetic signal and evolution.
}
\seealso{
\code{\link{procrustesFit}}, \code{\link{stdLM}}
}

