% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hsplot.R
\name{hsplot}
\alias{hsplot}
\title{Scatter plot with marginal histograms}
\usage{
hsplot(dat, seqx, seqy, ybound, xbound, y.label = "", x.label = "", labcol,
  type = "ru", sep1, sep2, phylo = FALSE, phy, pointscale = 1.5,
  supp.hist.y = FALSE, supp.hist.x = FALSE, y.axis.label = TRUE,
  x.axis.label = TRUE, addline = NULL)
}
\arguments{
\item{dat}{a matrix with rows representing species samples and two columns representing the variables of
interest (typically a selected principal component of size and shape variables)}

\item{seqx}{range of values on the x-axis, for histogram plotting}

\item{seqy}{range of values on the y-axis, for histogram plotting}

\item{ybound}{range of values on the y-axis}

\item{xbound}{range of values on the x-axis}

\item{y.label}{title for y-axis}

\item{x.label}{title for x-axis}

\item{labcol}{a character vector giving the color annotation for species names in alphabetical order}

\item{type}{a character that controls where the marginal histograms are located: right-up ("ru"), left-up ("lu"), left-down ("ld"), right-down ("rd")}

\item{sep1}{tick mark separation for x-axis}

\item{sep2}{tick mark separation for y-axis}

\item{phylo}{if TRUE, the centroids of species are joined into a tree-like object corresponding to their phylogeny given in \code{phy}}

\item{phy}{a tree object of class \code{phylo}}

\item{pointscale}{a constant specifying the symbol size of the centroids}

\item{supp.hist.y}{if TRUE, suppresses the plotting of marginal histogram at the y-axis}

\item{supp.hist.x}{if TRUE, suppresses the plotting of marginal histogram at the x-axis}

\item{y.axis.label}{if FALSE, suppresses the y-axis title}

\item{x.axis.label}{if FALSE, suppresses the x-axis title}

\item{addline}{an optional numeric vector of length two specifying the intercept and slope of linear line}
}
\description{
This function creates a scatter plot that is augmented with marginal histograms (with smoothed splines) on the x and y-axes.
}
\details{
This function is similar to \code{tpColorPlot2d}, and is mainly useful for its additional
option for visualising the marginal distributions. The \code{ape} and \code{phytools} packages are required.
}
\examples{
library(phytools)

data(pwed_pd)
data(ligotree)
data(spcolmap)

#principal component analysis of size variables from ventral and dorsal anchors
pca2d_pwedv <- pca2d(pwed_pd[,1:55], sgn=-1, labcol=spcolmap$color,
phylo=TRUE, phy=ligotree, genus="L. ", bound.y=c(-0.2, 0.2),
bound.x1=c(-0.2,0.2), bound.x2 = c(-0.2,0.2))
pca2d_pwedd <- pca2d(pwed_pd[,56:110], sgn=-1, labcol=spcolmap$color,
phylo=TRUE, phy=ligotree, genus="L. ", bound.y=c(-0.2, 0.2),
bound.x1=c(-0.2,0.2), bound.x2 = c(-0.2,0.2))

#comparing size PC1 between ventral and dorsal anchors
hsplot(cbind(pca2d_pwedv$scores[,1], pca2d_pwedd$scores[,1]),
seqx=seq(-0.2,0.15,0.01), seqy=seq(-0.2,0.15,0.01),
xbound=c(-0.2,0.15), ybound=c(-0.2,0.15), y.label="Dorsal size PC1",
x.label="Ventral size PC1", labcol=spcolmap$color, type="ru",
sep1=0.1, sep2=0.1, phylo=FALSE, addline=c(0,1))
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\references{
Khang TF, Soo OYM, Tan WB, Lim LHS. (2016). Monogenean anchor morphometry: systematic value, phylogenetic signal, and evolution. PeerJ 4:e1668.

Paradis E, Claude J & Strimmer K. (2004). APE: analyses of phylogenetics and evolution in R language. Bioinformatics 20: 289-290.

Revell LJ. (2012). phytools: An R package for phylogenetic comparative biology (and other things). Methods in Ecology and Evolution 3:217-223.
}

