% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/polyVis.R
\name{polyVis}
\alias{polyVis}
\title{Wireframe plot of monogenean anchor}
\usage{
polyVis(index, spacing = 250, havelist = FALSE, listdata = NULL,
  tit = "")
}
\arguments{
\item{index}{the index of a (tps) text file or matrix containing the (eleven) landmark coordinates in the following order: right ventral, left ventral, right dorsal, left dorsal}

\item{spacing}{a numeric constant specifying the spacing on the x and y coordinates relative to slide center}

\item{havelist}{choose TRUE if the landmark coordinate data are contained in a list}

\item{listdata}{a list containing objects that are matrices of 44 rows and 2 columns containing raw landmark coordinate data}

\item{tit}{title for the plot}
}
\description{
This function plots the ventral and dorsal anchors as polygons in their natural positions on the specimen slide.
}
\details{
This plot is useful for detecting slides with inconsistencies in magnification.
It is also useful for detecting poor quality samples, as indicated by large shape variation between left and right forms.
}
\examples{
data(ligophorus_tpsdata)
#Simultaneously visualise the first four specimen slides
par(mfrow=c(2,2))
par(mar=c(3,3,2,1.5))
mapply(function(k) polyVis(k, spacing=300, havelist=TRUE,
listdata=ligophorus_tpsdata$grandis), k=1:4)
}
\author{
Tsung Fei Khang \email{tfkhang@um.edu.my}
}
\references{
Khang TF, Soo OYM, Tan WB, Lim LHS. (2016). Monogenean anchor morphometry: systematic value, phylogenetic signal, and evolution. PeerJ 4:e1668.
}

