% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unimonotone.R
\name{unimonotone}
\alias{unimonotone}
\title{Unimodal Monotone Regression Function}
\usage{
unimonotone(x, w = rep(1, length(x)))
}
\arguments{
\item{x}{a real-valued vector.}

\item{w}{a real-valued vector with positive weights (default a vector with ones).}
}
\value{
Returns a real-valued vector with values of \code{x} in umbrella order.
}
\description{
\code{unimonotone} performs unimodal monotone regression.
The function follows the up-and-down-blocks implementation (Kruskal, 1964)
of the pool-adjacent-violators algorithm (Ayer, Brunk, Ewing, Reid, and Silverman, 1955)
for both isotonic and antitonic regression,
and the prefix isotonic regression approach (Stout, 2008)
with additional lookaheads and progressive error sum-of-squares computation.
}
\details{
Error checking on \code{x} or \code{w} is not present.
}
\examples{
y <- c( 0.0,61.9,183.3,173.7,250.6,238.1,292.6,293.8,268.0,285.9,258.8,
297.4,217.3,226.4,170.1,74.2,59.8,4.1,6.1 )
x <- unimonotone( y )
print( x )

}
\references{
Bril G, Dykstra R, Pillers C, Robertson T (1984).
  Algorithm AS 206: isotonic regression in two independent variables.
  Journal of the Royal Statistical Society. Series C (Applied Statistics), 33(3), 352-357. 
  URL https://www.jstor.org/stable/pdf/2347723.pdf.

  Busing, F.M.T.A. (2021). 
  Monotone Regression: A Simple and Fast O(n) PAVA Implementation. 
  Leiden University.

  Stout, Q.F. (2008).
  Unimodal Regression via Prefix Isotonic Regression.
  \emph{Computational Statistics and Data Analysis}, 53, pp. 289-297.
  URL https://doi:10.1016/j.csda.2008.08.005

  Turner, T.R. and Wollan, P.C. (1997).
  Locating a maximum using isotonic regression.
  \emph{Computational statistics and data analysis}, 25(3), pp. 305-320.
  URL https://doi.org/10.1016/S0167-9473(97)00009-1
  
  Turner, T.R. (2019).
  Iso: Functions to Perform Isotonic Regression.
  R package version 0.0-18.
  URL https://cran.r-project.org/package=Iso
}
