% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc.survFitPredict_Nsurv.R
\name{ppc.survFitPredict_Nsurv}
\alias{ppc.survFitPredict_Nsurv}
\title{Posterior predictive check plot for \code{survFitPredict_Nsurv} objects}
\usage{
\method{ppc}{survFitPredict_Nsurv}(x, xlab = "Observed nb of survivors",
  ylab = "Predicted nb of survivors", main = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{survFitPredict_Nsurv}}

\item{xlab}{A label for the \eqn{X}-axis, by default \code{Observed nb of survivors}.}

\item{ylab}{A label for the \eqn{Y}-axis, by default \code{Predicted nb of survivors}.}

\item{main}{A main title for the plot.}

\item{\dots}{Further arguments to be passed to generic methods}
}
\description{
This is the generic \code{ppc} S3 method for the \code{survFitPredict_Nsurv} class. It
plots the predicted values along with 95\% credible intervals
versus the observed values for \code{survFit} objects.
}
\details{
For \code{survFitPredict_Nsurv} object, PPC is based on times series simulated
for each replicate. In addition

The black points show the observed number of survivors (on \eqn{X}-axis)
 against the corresponding predicted
number (\eqn{Y}-axis). Predictions come along with 95\% prediction
intervals, which are depicted in green when they contain the
observed value and in red otherwise.
}
