% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregatingMeta.R
\name{mean_}
\alias{mean_}
\alias{sum}
\alias{min}
\alias{max}
\alias{mean}
\alias{median}
\alias{sd}
\alias{var}
\alias{cov}
\alias{cor}
\alias{favstats}
\alias{mean}
\alias{median}
\alias{range}
\alias{sd}
\alias{max}
\alias{min}
\alias{sum}
\alias{IQR}
\alias{fivenum}
\alias{iqr}
\alias{prod}
\alias{sum}
\alias{favstats}
\alias{quantile}
\alias{var}
\alias{cor}
\alias{cov}
\title{Aggregating functions}
\usage{
mean_(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm",
  FALSE))

mean(x, ...)

median(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm",
  FALSE))

range(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm",
  FALSE))

sd(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm", FALSE))

max(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm", FALSE))

min(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm", FALSE))

sum(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm", FALSE))

IQR(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm", FALSE))

fivenum(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm",
  FALSE))

iqr(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm", FALSE))

prod(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm",
  FALSE))

sum(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm", FALSE))

favstats(x, ..., data = NULL, groups = NULL, na.rm = TRUE)

quantile(x, ..., data = NULL, groups = NULL, na.rm = getOption("na.rm",
  FALSE))

var(x, y = NULL, na.rm = getOption("na.rm", FALSE), ..., data = NULL)

cor(x, y = NULL, ..., data = NULL)

cov(x, y = NULL, ..., data = NULL)
}
\arguments{
\item{x}{a numeric vector or a formula}

\item{\dots}{additional arguments}

\item{data}{a data frame in which to evaluate formulas (or bare names).
Note that the default is \code{data = parent.frame()}.  This makes it convenient to
use this function interactively by treating the working envionment as if it were
a data frame.  But this may not be appropriate for programming uses.
When programming, it is best to use an explicit \code{data} argument
-- ideally supplying a data frame that contains the variables mentioned.}

\item{groups}{a grouping variable, typically a name of a variable in \code{data}}

\item{na.rm}{a logical indicating whether \code{NA}s should be removed before computing}

\item{y}{a numeric vector or a formula}
}
\description{
The \code{mosaic} package makes several summary statistic functions (like \code{mean} and \code{sd})
formula aware.
}
\details{
Many of these functions mask core R functions to provide an additional formula
interface.  Old behavior should be unchanged.  But if the first argument is a formula,
that formula, together with \code{data} are used to generate the numeric vector(s)
to be summarized.  Formulas of the shape \code{x ~ a} or \code{~ x | a} can be used to
produce summaries of \code{x} for each subsect defined by \code{a}.  Two-way aggregation
can be achieved using formulas of the form \code{x ~ a + b} or \code{x ~ a | b}.  See
the examples.
}
\section{Note}{

Earlier versions of these functions supported a "bare name + data frame" interface.  This
functionality has been removed since it was (a) ambiguous in some cases, (b) unnecessary,
and (c) difficult to maintain.
}

\examples{
mean(HELPrct$age)
mean( ~ age, data = HELPrct)
mean( ~ drugrisk, na.rm = TRUE, data = HELPrct)
mean(age ~ shuffle(sex), data = HELPrct)
mean(age ~ shuffle(sex), data = HELPrct, .format = "table")
# wrap in data.frame() to auto-convert awkward variable names
data.frame(mean(age ~ shuffle(sex), data = HELPrct, .format = "table"))
mean(age ~ sex + substance, data = HELPrct)
mean( ~ age | sex + substance, data = HELPrct)
mean( ~ sqrt(age), data = HELPrct)
sum( ~ age, data = HELPrct)
sd(HELPrct$age)
sd( ~ age, data = HELPrct)
sd(age ~ sex + substance, data = HELPrct)
var(HELPrct$age)
var( ~ age, data = HELPrct)
var(age ~ sex + substance, data = HELPrct)
IQR(width ~ sex, data = KidsFeet)
iqr(width ~ sex, data = KidsFeet)
favstats(width ~ sex, data = KidsFeet)

cor(length ~ width, data = KidsFeet)
cov(length ~ width, data = KidsFeet)
tally(is.na(mcs) ~ is.na(pcs), data = HELPmiss)
cov(mcs ~ pcs, data = HELPmiss)             # NA because of missing data
cov(mcs ~ pcs, data = HELPmiss, use = "complete")  # ignore missing data
# alternative approach using filter explicitly
cov(mcs ~ pcs, data = HELPmiss \%>\% filter(!is.na(mcs) & !is.na(pcs)))    
}
