#' Cross tabulation displayed as percents or proportions
#' 
#' `perctable` and `proptable` use the cross-classifying factors to build a 
#' contingency table of the percents or proportions at each combination of factor levels.
#' @param \dots  
#'   arguments passed directly to [table()];  typically
#'   one or more objects which can be interpreted as factors (including character strings), 
#'   or a list (or data frame) whose components can be so interpreted. 
#' 
#' @details See [table()].
#' @return a contingency table, an object of class "table", an array of percentage or proportion
#' values. Note that unlike S the result is always an array, a 1D array if one factor is given.
#' @examples
#' # perctable() is now defunct.  Use `tally()` instead
#' example(tally)
#' 
#' @keywords manipulate 
#' @export

perctable <- function(...) 
{
  .Defunct("tally")
	t <- table(...)
	t/sum(t) * 100
}

#' @rdname perctable
#' @export

proptable <- function(...) 
{
  .Deprecated("tally")
	t <- table(...)
	t/sum(t) 
}

