% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BirthsDoc.R
\docType{data}
\name{Birthdays}
\alias{Birthdays}
\title{US Births in 1969 - 1988}
\format{
A data frame with 374221 observations on the following variables.
\itemize{
\item{\code{state}} {state where child was born}
\item{\code{year}} {year (1969-1988)}
\item{\code{month}} {month (1-12)}
\item{\code{day}} {day of month}
\item{\code{date}} {date as a date object}
\item{\code{births}} {number of births}
}
}
\usage{
data(Birthdays)
}
\description{
A day by day record of the number of births in each US State.
}
\examples{
data(Birthdays)
if (require(mosaic)) {
  MI <- Birthdays \%>\% filter(state == "MI")
  gf_point(births ~ date, Birthdays, data = MI)
  gf_line(births ~ date, Birthdays, data = MI, color = ~ wday)
  gf_line(births ~ date,
    data = Birthdays \%>\% group_by(date) \%>\% summarise(births = sum(births)))
  }
}
\seealso{
\code{Births}, \code{Births78}, \code{Births2015}, \code{BirthsSSA}, \code{BirthsCDC} for data sets that are
aggregated at the level of the entire country.
}
