% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{mutUniformReset}
\alias{mutUniformReset}
\title{Uniform Reset for Binary Parameters}
\usage{
mutUniformReset(ind, p = 0.1, reset.dist)
}
\arguments{
\item{ind}{\verb{[integer]} binary individual with values 0 or 1.}

\item{p}{\verb{[numeric(1)]} entry-wise reset probability.}

\item{reset.dist}{\verb{[numeric]} probability to draw 1-bit per entry, if reset is performed.
\code{reset.dist} can be length 1 or same length as \code{ind} (which uses a different distribution for each bit).}
}
\value{
\verb{[integer]} the mutated individual.
}
\description{
For each bit individually, decide with probability \code{p} to "reset" it to an
equilibrium distribution which is specified by \code{reset.dist}: a bit being
reset is set to 1 with probability \code{reset.dist} and set to 0 with probability
(1 - \code{reset.dist}).
}
