% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contemporaryPhy.R
\name{contemporaryPhy}
\alias{contemporaryPhy}
\title{prune tree and data to lineages present in a time bin in the past}
\usage{
contemporaryPhy(phy, maxBin, minBin, reScale = 0, allTraits,
  closest.min = TRUE, traits.from.tip = TRUE)
}
\arguments{
\item{phy}{An object of class \code{phylo} (see \pkg{ape}).}

\item{maxBin}{the start age (older time in myr from present) of the time bin in which lineages are preserved}

\item{minBin}{the final age (younger time in myr from present) of the time bin in which lineages are preserved}

\item{reScale}{if the most recent tip is not from the present, the age needed to add so the phylogeny is in 'real time'}

\item{allTraits}{a vector of trait data corresponding to the phy$edge object. The trait data represent tip and internal node data for the phylogeny}

\item{closest.min}{Logical. Should new tip values for lineages that span the bin be taken from the node nearest the \code{minBin} age (\code{closest.min=TRUE}, default) or the \code{maxBin} age \code{closest.min=FALSE}}

\item{traits.from.tip}{Logical. Should tip values for pendant edges in the bin be taken from the original tip value or the reconstructed node value (if it is closer than the tip value)}
}
\value{
the pruned phylogeny. The object \code{descendants} refers to the lineages the branch in the time bin gave rise to before it was pruned. If traits are included a vector of trait values representing species at the tips.
}
\description{
the function takes a full tree and returns a pruned phylogeny with only tips and lineages found within a time bin preserved. If trait data are supplied the function will return tip states based either on the original tips found in the bin, or tip states inferred from ancestral states
}
\examples{
## prune a random tree to taxa present between 4 and 2 units before present
# generate tree
set.seed(20)
tree <- rtree(20)
# generate traits
traits <- rnorm(20)
# plot tree and timeframe
plot(tree)
max.age <- nodeTimes(tree)[1,1]
abline(v=max.age - c(4, 2))
# prune tree to timeframe
cont.tree <- contemporaryPhy(phy=tree, maxBin=4, minBin=2, allTraits=traits)
plot(cont.tree$phy)
}
\references{
Puttick, M. N., Kriwet, J., Wen, W., Hu, S., Thomas, G. H., & Benton, M. J. (2017). Body length of bony fishes was not a selective factor during the biggest mass extinction of all time. Palaeontology, 60, 727-741.
}
\author{
Mark Puttick
}
