% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mt_example}
\alias{mt_example}
\title{A mousetrap data object.}
\format{A mousetrap data object is a \link{list} containing  at least the
  following objects:
  \itemize{
    \item{\code{data}: \link{data.frame} containing the trial data (from
    which the mouse-tracking data columns have been removed). More
    information about the content of the trial data in \code{mt_example} can
    be found in \link{mt_example_raw}.}
    \item{\code{trajectories}: \link{array} containing raw mouse-tracking
    trajectories. The first dimension represents the different trials. It
    uses the ID of the trial as names (this ID is by default logged under
    \link{mt_id} in \code{data}). The second dimension corresponds to the
    different variables (timestamps, x-positions, y-positions) with the names
    as specified in \link{mt_variable_labels} (by default: \code{timestamps},
    \code{xpos}, \code{ypos}). The third dimension corresponds to the samples
    taken over time, which are included in chronological order and carry
    successive integers as labels.}
  }

  Some functions in this package (e.g., \link{mt_time_normalize} and
  \link{mt_average}) add additional trajectory arrays (e.g.,
  \code{tn_trajectories} and \code{av_trajectories}) to the mousetrap data
  object. Other functions modify the existing arrays (e.g.,
  \link{mt_calculate_derivatives} adds distance, velocity, and acceleration
  to an existing dataset). Finally \link{mt_calculate_measures} adds an
  additional data.frame with mouse-tracking measures to it.}
\usage{
mt_example
}
\description{
A mousetrap data object with example data created by importing
\link{mt_example_raw} and applying basic post-processing.
}
\details{
The raw data set was imported using \link{mt_import_mousetrap}. Trajectories 
were then remapped using \link{mt_remap_symmetric} so that all trajectories 
end in the top-left corner and their starting point was aligned using
\link{mt_align_start} to a common value (0,0).
}
\keyword{datasets}

