% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{mt_export_long}
\alias{mt_export_long}
\alias{mt_export_wide}
\title{Export mouse-tracking data.}
\usage{
mt_export_long(data, use = "trajectories", use_variables = NULL,
  use2 = "data", use2_variables = NULL, ...)

mt_export_wide(data, use = "trajectories", use_variables = NULL,
  use2 = "data", use2_variables = NULL, ...)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which data should be exported. The 
corresponding data are selected from data using \code{data[[use]]}. 
Usually, this value corresponds to either "trajectories" or
"tn_trajectories", depending on whether the raw or the time-normalized
trajectories should be exported.}

\item{use_variables}{a character vector specifying which mouse-tracking 
variables should be exported. This corresponds to the labels of the
trajectory array dimensions. If unspecified, all variables will be
exported.}

\item{use2}{an optional character string specifying where the other trial
data can be found. Defaults to "data" as \code{data[["data"]]} usually
contains all non mouse-tracking trial data. Alternatively, a data.frame can
be provided directly.}

\item{use2_variables}{an optional character string (or vector) specifying the
variables (in \code{data[[use2]]}) that should be merged with the data.}

\item{...}{additional arguments passed on to \link{mt_reshape} (such as 
\code{subset}).}
}
\value{
A \link{data.frame} containing the exported data.
}
\description{
\code{mt_export_long} and \code{mt_export_wide} can be used for exporting 
mouse-tracking data from a mousetrap data object in long or wide format. If
desired, additional data (stored in \code{data[[use2]]}) can be merged with
the trajectory data before export. \code{mt_export_long} and 
\code{mt_export_wide} are wrapper functions for \link{mt_reshape}.
}
\section{Functions}{
\itemize{
\item \code{mt_export_long}: Export mouse-tracking data in long format

\item \code{mt_export_wide}: Export mouse-tracking data in wide format
}}

\examples{
# Export data in long format
# (and include information about condition and subject_nr)
mt_data_long <- mt_export_long(mt_example,
  use2_variables=c("subject_nr","Condition"))

# Export data in wide format
# (and include information about condition and subject_nr)
mt_data_wide <- mt_export_wide(mt_example,
  use2_variables=c("subject_nr","Condition"))

}
\seealso{
\link{mt_import_long} for importing mouse-tracking data saved in a
  long format.

  \link{mt_import_wide} for importing mouse-tracking data saved in a wide 
  format.
}
\author{
Pascal J. Kieslich (\email{kieslich@psychologie.uni-mannheim.de})

Felix Henninger
}
