% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_segments.R
\name{mt_segments}
\alias{mt_segments}
\title{Create a \code{LINESTRING} for each track segment}
\usage{
mt_segments(x)
}
\arguments{
\item{x}{A \code{move2} object.}
}
\value{
A \code{sfc} object containing \code{LINESTRING}s for each segment of a trajectory.
}
\description{
Creates a \code{LINESTRING} for each segment between consecutive points within a track.
}
\details{
The last location of each track is formed by a \code{POINT} as no segment can be formed.
}
\examples{
track <- mt_sim_brownian_motion()
mt_segments(track)
## adding the segments as an attribute to the move2 object
track$segments <- mt_segments(track)
track

}
\seealso{
\itemize{
\item \code{\link[=mt_track_lines]{mt_track_lines()}} For transforming the full tracks into one \code{LINESTRING}.
}
}
