% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_track_id.R
\name{mt_track_data}
\alias{mt_track_data}
\alias{mt_set_track_data}
\title{Setting and retrieving the track data in \code{move2} objects}
\usage{
mt_track_data(x)

mt_set_track_data(x, data)
}
\arguments{
\item{x}{the \code{move2} object}

\item{data}{the new track data. This \code{data.frame} must contain the column
with the track ids, the column name must be the same as in the \code{move2} object.}
}
\value{
\code{mt_track_data} returns a data.frame containing the track attribute data.\cr
\code{mt_set_track_data} returns the \code{move2} object with updated track data
}
\description{
\itemize{
\item \code{mt_track_data()} retrieve track attribute table
\item \code{mt_set_track_data()} replace the attribute table
\item 
}
}
\examples{
mt_sim_brownian_motion() |>
  mutate_track_data(sex = c("f", "m")) |>
  mt_track_data()
x <- mt_sim_brownian_motion(1:2, tracks = letters[1:4])
mt_set_track_data(x, data.frame(track = letters[1:4], age = 2:5))
}
