% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_meta.R
\encoding{UTF-8}
\name{run_meta_loocv}
\alias{run_meta_loocv}
\title{Running LOOCV on hierarchical model outputs}
\usage{
run_meta_loocv(
  rv,
  set_target = c("hr", "ctsd"),
  subpop = FALSE,
  trace = FALSE,
  .progress = FALSE,
  .only_max_m = TRUE,
  .lists = NULL
)
}
\arguments{
\item{rv}{A list containing outputs, settings and data objects. Must not be NULL.}

\item{set_target}{Character. Research target: \code{"hr"} for home range or \code{"ctsd"} for speed & distance.}

\item{subpop}{Logical. If TRUE, will run meta-analyses with groups. Default is FALSE.}

\item{trace}{Logical. If TRUE, prints progress messages. Default is FALSE.}

\item{.progress}{Logical. If TRUE, will display a progress bar. Default is FALSE.}

\item{.only_max_m}{Logical. If TRUE, will only run the maximum number of individuals. Default is FALSE.}

\item{.lists}{A list containing already created meta inputs. Default is NULL.}
}
\value{
A data frame containing meta-analysis outputs, including estimates, errors, confidence intervals, and group information.
}
\description{
This function runs hierarchical models on movement tracking data,
for mean home range area (AKDE) or continuous-time speed and distance (CTSD)
estimates for a sampled population. It leverages the \code{ctmm} R package,
specifically the \code{meta()} function, to obtain population-level mean parameters.
This function helps to assess outputs via leave-one-out cross-validation (LOOCV).
}
\examples{
if(interactive()) {
run_meta_loocv(rv, set_target = "hr")
}

}
\author{
Inês Silva \email{i.simoes-silva@hzdr.de}
}
