% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\name{get_spliced_view}
\alias{get_spliced_view}
\title{Get spliced view from view object}
\usage{
get_spliced_view(v, splicing_df)
}
\arguments{
\item{v}{View object}

\item{splicing_df}{\code{Splice} object.}
}
\value{
a \code{SplicedView} object.
}
\description{
Get spliced view from view object
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
l <- list(a = c(0, 10), b = c(10, 20), c = c(20, 30))
splicing_df <- splice_time(l)
sv <- get_spliced_view(rv, splicing_df)
}
\seealso{
Other splicing functions: 
\code{\link{clip_splice}()},
\code{\link{is_splice_overlapping}()},
\code{\link{merge_splice}()},
\code{\link{splice_time.Duration}()},
\code{\link{splice_time.Metre}()},
\code{\link{splice_time.OnsetsDifference}()},
\code{\link{splice_time.View}()},
\code{\link{splice_time.list}()},
\code{\link{splice_time}()},
\code{\link{split.SplicedView}()}
}
\concept{splicing functions}
