% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tSNE.R
\name{tSNE}
\alias{tSNE}
\title{t-Distributed Stochastic Neighbor Embedding}
\usage{
tSNE(X, Y = NULL, k = 2, perplexity = 30, n.iter = 1000)
}
\arguments{
\item{X}{A data frame, data matrix, dissimilarity (distance) matrix or dist
object.}

\item{Y}{Initial k-dimensional configuration. If NULL, the method uses a
random initial configuration.}

\item{k}{Target dimensionality. Avoid anything other than 2 or 3.}

\item{perplexity}{A rough upper bound on the neighborhood size.}

\item{n.iter}{Number of iterations to perform.}
}
\value{
The k-dimensional representation of the data.
}
\description{
Creates a k-dimensional representation of the data by modeling the
probability of picking neighbors using a Gaussian for the high-dimensional
data and t-Student for the low-dimensional map and then minimizing the KL
divergence between them. This implementation uses the same default parameters
as defined by the authors.
}
\examples{
# Iris example
emb <- tSNE(iris[, 1:4])
plot(emb, col=iris$Species)
}
\references{
L.J.P. van der Maaten and G.E. Hinton. _Visualizing
High-Dimensional Data Using t-SNE._ Journal of Machine Learning Research
9(Nov): 2579-2605, 2008.
}

