(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    127930,       3632]
NotebookOptionsPosition[    125314,       3560]
NotebookOutlinePosition[    125843,       3581]
CellTagsIndexPosition[    125800,       3578]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"otherPairState", "[", "state_", "]"}], " ", ":=", " ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{"state", ",", "2"}], "]"}], " ", "\[Equal]", " ", "0"}], ",", 
     RowBox[{"state", "-", "1"}], ",", 
     RowBox[{"state", "+", "1"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"startRelevant2", "[", "state_", "]"}], " ", ":=", " ", 
   RowBox[{"state", " ", "-", " ", 
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"state", "+", "1"}], ",", " ", "2"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"startRelevant4", "[", "state_", "]"}], " ", ":=", " ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"state", " ", "\[GreaterEqual]", " ", "5"}], ",", " ", "5", ",", 
     " ", "1"}], "]"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"allPermutations", "[", "current_", "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "permutationsOf", ",", " ", "horizontal", ",", " ", "vertical", ",", " ",
       "both"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"permutationsOf", " ", "=", " ", 
      RowBox[{"PermutationReplace", "[", 
       RowBox[{"current", ",", " ", "permutations"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"horizontal", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vertical", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"both", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"Join", "[", 
       RowBox[{
       "permutationsOf", ",", " ", "horizontal", ",", " ", "vertical", ",", 
        " ", "both"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Eight", "-", 
    RowBox[{"way", " ", "states"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"permutations", " ", "=", " ", 
     RowBox[{"GroupElements", "[", 
      RowBox[{"PermutationGroup", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"5", ",", "6"}], "}"}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"7", ",", "8"}], "}"}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "3"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"5", ",", "7"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"6", ",", "8"}], "}"}]}], "}"}], "]"}], ",", " ", 
         RowBox[{"Cycles", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "5"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"2", ",", "6"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"3", ",", "7"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"4", ",", "8"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"originalStates", " ", "=", " ", 
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"1", ",", "8"}], "]"}], ",", " ", "4"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "Symmetries", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"standardiseUsingPermutation", "[", 
     RowBox[{"{", 
      RowBox[{"unique_", ",", " ", "standardised_", ",", " ", "remaining_"}], 
      "}"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"current", ",", "positions", ",", "permutationsOfCurrent"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"current", " ", "=", " ", 
        RowBox[{"First", "[", "remaining", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"permutationsOfCurrent", " ", "=", " ", 
        RowBox[{"allPermutations", "[", "current", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"positions", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"Position", "[", 
           RowBox[{"unique", ",", "#1"}], "]"}], "&"}], "/@", 
         "permutationsOfCurrent"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Plus", "@@", 
           RowBox[{"(", 
            RowBox[{"Flatten", "[", "positions", "]"}], ")"}]}], " ", 
          "\[Equal]", " ", "0"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Append", "[", 
            RowBox[{"unique", ",", " ", "current"}], "]"}], ",", " ", 
           RowBox[{"Append", "[", 
            RowBox[{"standardised", ",", " ", "current"}], "]"}], ",", " ", 
           RowBox[{"Rest", "[", "remaining", "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"unique", ",", " ", 
           RowBox[{"Append", "[", 
            RowBox[{"standardised", ",", " ", 
             RowBox[{"unique", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"Flatten", "[", "positions", "]"}], "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
           " ", 
           RowBox[{"Rest", "[", "remaining", "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"recursiveResults", " ", "=", " ", 
     RowBox[{"Nest", "[", 
      RowBox[{"standardiseUsingPermutation", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "}"}], ",", " ", 
         RowBox[{"{", "}"}], ",", " ", "originalStates"}], "}"}], ",", 
       RowBox[{"Length", "[", "originalStates", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"states", " ", "=", " ", 
     RowBox[{"recursiveResults", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"statesWithCounts", "=", 
    RowBox[{"Tally", "[", "states", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Length", "[", "statesWithCounts", "]"}], "\[IndentingNewLine]", 
   RowBox[{"states", " ", "=", " ", 
    RowBox[{"First", " ", "/@", "statesWithCounts"}]}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rilMatrixFunction", "[", 
   RowBox[{"from_", ",", " ", "to_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "twoRecomb", ",", " ", "twoNonRecomb", ",", " ", "oneEach", ",", " ", 
      "twoRecombMatches", ",", " ", "twoNonRecombMatches", ",", " ", 
      "oneEachMatches", ",", " ", "permutationsOfTo"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"permutationsOfTo", " ", "=", " ", 
      RowBox[{"allPermutations", "[", "to", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"twoRecomb", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"twoNonRecomb", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"oneEach", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"from", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"from", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"twoRecombMatches", " ", "=", " ", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"twoRecomb", ",", " ", "#1"}], "]"}], "]"}], "&"}], "/@", 
         "permutationsOfTo"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"twoNonRecombMatches", " ", "=", " ", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"twoNonRecomb", ",", " ", "#1"}], "]"}], "]"}], "&"}], "/@",
          "permutationsOfTo"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"oneEachMatches", " ", "=", " ", 
      RowBox[{"Plus", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", 
           RowBox[{"Position", "[", 
            RowBox[{"oneEach", ",", " ", "#1"}], "]"}], "]"}], "&"}], "/@", 
         "permutationsOfTo"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"twoRecombMatches", " ", 
       FractionBox[
        SuperscriptBox["r", "2"], "4"]}], " ", "+", " ", 
      RowBox[{"twoNonRecombMatches", " ", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "r"}], ")"}], "2"], "4"]}], " ", "+", " ", 
      RowBox[{"oneEachMatches", " ", "r", 
       FractionBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], "4"]}]}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rilMatrix", " ", "=", " ", 
   RowBox[{
    RowBox[{"Outer", "[", 
     RowBox[{
     "rilMatrixFunction", ",", " ", "states", ",", " ", "states", ",", "1"}], 
     "]"}], "//", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TableForm", "[", 
  RowBox[{"rilMatrix", ",", " ", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"states", ",", " ", "states"}], "}"}]}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "These", " ", "should", " ", "all", " ", "sum", " ", "to", " ", "1"}], 
  "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Plus", "@@", "#1"}], ")"}], "&"}], "/@", "rilMatrix"}], " ", "//",
   "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Check", " ", "that", " ", "eigen", " ", "decomposition", " ", "works"}], 
   ",", " ", 
   RowBox[{
   "difference", " ", "should", " ", "be", " ", "a", " ", "zero", " ", 
    "matrix"}]}], "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"decomposed", " ", "=", " ", 
   RowBox[{
    RowBox[{"Inverse", "[", 
     RowBox[{"Eigenvectors", "[", 
      RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}], "]"}], " ", ".", 
    " ", 
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"Eigenvalues", "[", "rilMatrix", "]"}], "]"}], ".", 
    RowBox[{"Eigenvectors", "[", 
     RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"decomposed", " ", "-", " ", "rilMatrix"}], "//", 
  "FullSimplify"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Use", " ", "eigen", " ", "decomposition", " ", "to", " ", "take", " ", 
   "power"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"power", " ", "=", " ", 
   RowBox[{
    RowBox[{"Inverse", "[", 
     RowBox[{"Eigenvectors", "[", 
      RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}], "]"}], " ", ".", 
    " ", 
    RowBox[{"MatrixPower", "[", 
     RowBox[{
      RowBox[{"DiagonalMatrix", "[", 
       RowBox[{"Eigenvalues", "[", "rilMatrix", "]"}], "]"}], ",", "d"}], 
     "]"}], ".", 
    RowBox[{"Eigenvectors", "[", 
     RowBox[{"Transpose", "[", "rilMatrix", "]"}], "]"}]}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Check", " ", "that", " ", "the", " ", "limit", " ", "looks", " ", "right",
     " ", "in", " ", "the", " ", "case", " ", "of", " ", "infinite", " ", 
    "selfing"}], ",", " ", 
   RowBox[{"no", " ", "intercrossing"}]}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rilLimit", " ", "=", " ", 
   RowBox[{"Limit", "[", 
    RowBox[{"power", ",", " ", 
     RowBox[{"d", "\[Rule]", " ", "\[Infinity]"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"0", " ", "<", " ", "r"}], " ", "&&", " ", 
       RowBox[{"r", " ", "<", " ", 
        RowBox[{"1", "/", "2"}]}]}]}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"haplotypeProbability", "[", 
   RowBox[{"state1_", ",", "state2_"}], "]"}], " ", ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"startRelevant4", "[", "state1", "]"}], " ", "\[NotEqual]", " ", 
     
     RowBox[{"startRelevant4", "[", "state2", "]"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{"Different", " ", "halves"}], "*)"}], "\[IndentingNewLine]", "0",
     ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{"The", " ", "same", " ", "half"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"startRelevant2", "[", "state1", "]"}], " ", "\[NotEqual]", 
       " ", 
       RowBox[{"startRelevant2", "[", "state2", "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "Different", " ", "pairs", " ", "within", " ", "the", " ", "same", " ",
         "4"}], "*)"}], "\[IndentingNewLine]", 
      FractionBox["r", "8"], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"The", " ", "same", " ", "pair"}], ",", " ", 
        RowBox[{
        "so", " ", "they", " ", "could", " ", "be", " ", "the", " ", 
         "same"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"state1", " ", "\[Equal]", " ", "state2"}], ",", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], "2"], "4"], ",", 
        RowBox[{"r", 
         FractionBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], "4"]}]}], "]"}]}], 
     "\[IndentingNewLine]", "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"initialProbabilities", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"state", ",", " ", "count"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"state", " ", "=", " ", 
         RowBox[{"#1", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"count", " ", "=", " ", 
         RowBox[{"#1", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"startRelevant4", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "\[Equal]", " ", 
            RowBox[{"startRelevant4", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{"startRelevant4", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "]"}], " ", "\[Equal]", " ", 
            RowBox[{"startRelevant4", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{"startRelevant4", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "\[NotEqual]", " ", 
            
            RowBox[{"startRelevant4", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{"startRelevant4", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "\[NotEqual]", " ", 
            
            RowBox[{"startRelevant4", "[", 
             RowBox[{"state", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "]"}]}]}], ",", "0", ",", 
          RowBox[{
           FractionBox["count", "2"], " ", 
           RowBox[{"haplotypeProbability", "[", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", "3", "]"}], "]"}]}], "]"}], 
           RowBox[{"haplotypeProbability", "[", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}]}], "]"}]}]}], "]"}], 
     "&"}], "/@", "statesWithCounts"}]}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", " ", "@@", "initialProbabilities"}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[{
 RowBox[{"infiniteSelfing", " ", "=", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"initialProbabilities", " ", ".", " ", "rilLimit"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"#1", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ")"}], "&"}], "/@", 
       "statesWithCounts"}], ")"}]}], " ", "//", "FullSimplify"}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{"Pick", "[", 
  RowBox[{"states", ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#1", " ", "=!=", " ", "0"}], ")"}], "&"}], "/@", 
    "infiniteSelfing"}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Probabilities", " ", "for", " ", "a", " ", "finite", " ", "number", " ", 
    "of", " ", "generations", " ", "of", " ", "selfing"}], ",", " ", 
   RowBox[{
    RowBox[{"no", " ", 
     RowBox[{"intercossing", ".", " ", "This"}], " ", "can", " ", "be", " ", 
     "worked", " ", "out", " ", "for", " ", "the", " ", "4"}], "-", 
    RowBox[{
    "way", " ", "design", " ", "just", " ", "based", " ", "on", " ", "the", 
     " ", "2"}], "-", 
    RowBox[{"way", " ", "design"}]}], ",", " ", 
   RowBox[{
   "and", " ", "it", " ", "should", " ", "match", " ", "the", " ", 
    "eigenvalue", " ", "calculation", " ", "above"}]}], " ", "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"fromPaper2way", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", "r"}]}], ")"}]}]], " ", "-", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "2"], ")"}], 
        RowBox[{"d", "+", "2"}]], 
       RowBox[{"(", 
        RowBox[{"2", " ", "-", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", " ", "-", " ", 
            RowBox[{"2", " ", "r"}], " ", "+", " ", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "d"], " ", "+", " ", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", "r"}]}], ")"}], 
           RowBox[{"d", "+", "1"}]], 
          RowBox[{"1", "+", 
           RowBox[{"2", "r"}]}]]}], ")"}]}]}], ",", " ", 
     RowBox[{
      FractionBox["r", 
       RowBox[{"1", "+", 
        RowBox[{"2", "r"}]}]], " ", "-", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "2"], ")"}], 
        RowBox[{"d", "+", "2"}]], 
       RowBox[{"(", 
        RowBox[{"2", " ", "-", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", " ", "-", " ", 
            RowBox[{"2", " ", "r"}], " ", "+", " ", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], "d"], " ", "-", " ", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", " ", "-", " ", 
             RowBox[{"2", "r"}]}], ")"}], 
           RowBox[{"d", "+", "1"}]], 
          RowBox[{"1", "+", 
           RowBox[{"2", "r"}]}]]}], ")"}]}]}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}], 
       RowBox[{"d", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{"1", " ", "-", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", "r"}], " ", "+", " ", 
           RowBox[{"2", 
            SuperscriptBox["r", "2"]}]}], ")"}], "d"]}], ")"}]}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}], 
       RowBox[{"d", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", " ", "r"}], " ", "+", " ", 
           RowBox[{"2", 
            SuperscriptBox[
             RowBox[{"r", " "}], "2"]}]}], ")"}], "d"], " ", "+", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", "r"}]}], " ", ")"}], "d"]}], ")"}]}], ",", " ", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "2"], ")"}], 
       RowBox[{"d", "+", "1"}]], 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", " ", "r"}], " ", "+", " ", 
           RowBox[{"2", 
            SuperscriptBox[
             RowBox[{"r", " "}], "2"]}]}], ")"}], "d"], " ", "-", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"2", "r"}]}], " ", ")"}], "d"]}], ")"}]}]}], "}"}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Plus", " ", "@@", " ", 
   RowBox[{"(", 
    RowBox[{"fromPaper2way", "*", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "4", ",", "1", ",", "1"}], "}"}]}], ")"}]}],
   " ", "//", "FullSimplify"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"permutationsF2", " ", "=", " ", 
   RowBox[{"GroupElements", "[", 
    RowBox[{"PermutationGroup", "[", 
     RowBox[{"{", 
      RowBox[{"Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}], "}"}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"allPermutationsF2", "[", "current_", "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "permutationsOf", ",", " ", "horizontal", ",", " ", "vertical", ",", " ",
       "both"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"permutationsOf", " ", "=", " ", 
      RowBox[{"PermutationReplace", "[", 
       RowBox[{"current", ",", " ", "permutationsF2"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"horizontal", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"vertical", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"both", " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "&"}], "/@", 
       "permutationsOf"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"DeleteDuplicates", "[", 
      RowBox[{"Join", "[", 
       RowBox[{
       "permutationsOf", ",", " ", "horizontal", ",", " ", "vertical", ",", 
        " ", "both"}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"expected8wayFiniteSelfingMatrixFunction", " ", "=", " ", 
   RowBox[{"Function", "[", 
    RowBox[{"state", ",", " ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "toStates", ",", " ", "permutationsToStates", ",", " ", "result", ",",
          " ", "positions", ",", " ", "indices", ",", " ", "f2Permutations"}],
         "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"result", " ", "=", " ", 
         RowBox[{"ConstantArray", "[", 
          RowBox[{"0", ",", " ", 
           RowBox[{"Length", "[", "states", "]"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "A", ",", "A", ",", "A"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{"fromPaper2way", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "A", ",", "B", ",", "B"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{"fromPaper2way", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "A", ",", "A", ",", "B"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], 
              RowBox[{"fromPaper2way", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "B", ",", "A", ",", "B"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "1", ",", "2"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], 
              RowBox[{"fromPaper2way", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{"A", ",", "B", ",", "B", ",", "A"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"f2Permutations", " ", "=", " ", 
         RowBox[{"allPermutationsF2", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "2", ",", "1"}], "}"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"toStates", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{"#1", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "+", "2"}], "]"}], "]"}], 
             ",", " ", 
             RowBox[{"state", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "4", "]"}], "]"}], "+", "2"}], "]"}], "]"}]}], 
            "}"}], "&"}], "/@", "f2Permutations"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"permutationsToStates", " ", "=", " ", 
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"allPermutations", "/@", "toStates"}], ",", "1"}], "]"}]}],
         ";", "\[IndentingNewLine]", 
        RowBox[{"positions", " ", "=", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Position", "[", 
            RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
          "permutationsToStates"}]}], ";", 
        RowBox[{"indices", " ", "=", " ", 
         RowBox[{"Flatten", "[", "positions", "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"result", "[", 
             RowBox[{"[", "#1", "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"result", "[", 
              RowBox[{"[", "#1", "]"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], 
              RowBox[{"fromPaper2way", "[", 
               RowBox[{"[", "5", "]"}], "]"}]}]}]}], ")"}], "&"}], "/@", 
         "indices"}], ";", "\[IndentingNewLine]", 
        RowBox[{"result", "//", "FullSimplify"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], "]"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"expected8wayFiniteSelfingMatrix", " ", "=", 
   RowBox[{"expected8wayFiniteSelfingMatrixFunction", "/@", "states"}]}], 
  ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Plus", "@@", "#1"}], ")"}], "&"}], "/@", 
   "expected8wayFiniteSelfingMatrix"}], "//", "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"expected8wayFiniteSelfing", "=", 
   RowBox[{"initialProbabilities", ".", "expected8wayFiniteSelfingMatrix"}]}],
   ";"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", "expected8wayFiniteSelfing"}], "//", 
  "FullSimplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{"expected8wayFiniteSelfing", ",", " ", 
    RowBox[{"d", "\[Rule]", "\[Infinity]"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", " ", 
     RowBox[{
      RowBox[{"0", " ", "<", " ", "r"}], " ", "&&", " ", 
      RowBox[{"r", " ", "<", " ", 
       RowBox[{"1", "/", "2"}]}]}]}]}], "]"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], ")"}], "&"}], "/@", 
    "statesWithCounts"}], ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Ok", ",", " ", 
    RowBox[{
    "so", " ", "we", " ", "correctly", " ", "recreated", " ", "the", " ", 
     "results", " ", "from", " ", "the", " ", 
     RowBox[{"paper", ".", " ", "But"}], " ", "now", " ", "what", " ", 
     "about", " ", "the", " ", "case", " ", "where", " ", "there", " ", "is", 
     " ", 
     RowBox[{"intercrossing", "?", "\[IndentingNewLine]", "The"}], " ", 
     "linkage", " ", "disequilibrium", " ", "coefficient", " ", 
     RowBox[{"doesn", "'"}], "t", " ", "work", " ", 
     RowBox[{"here", ".", " ", "So"}], " ", "we", " ", "need", " ", "to", " ",
      "work", " ", "out", " ", "the", " ", "effect", " ", "on", " ", "the", 
     " ", "haplotypes", " ", "of", " ", 
     RowBox[{"intercrossing", ".", " ", "For"}], " ", "these", " ", 
     "purposes", " ", "we", " ", "need", " ", "4", " ", "states", " ", "AA"}],
     ",", " ", "AB", ",", " ", 
    RowBox[{"AC", " ", "and", " ", 
     RowBox[{"AE", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Once", " ", "the", " ", "eight", " ", "founders", " ", "are", " ", 
     "crossed"}], ",", " ", 
    RowBox[{"we", " ", "have"}], ",", " ", 
    RowBox[{"AA", " ", "=", " ", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], "3"], "8"]}], ",", " ", 
    RowBox[{"AB", " ", "=", " ", 
     RowBox[{"r", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "r"}], ")"}], "2"], "8"]}]}], ",", " ", 
    RowBox[{"AC", " ", "=", " ", 
     FractionBox[
      RowBox[{"r", 
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}]}], "16"]}], ",", " ", 
    RowBox[{"AE", " ", "=", " ", 
     FractionBox["r", "32"]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "r"}], ")"}], "3"], " ", "+", " ", 
    RowBox[{"r", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "r"}], ")"}], "2"]}], " ", "+", " ", 
    RowBox[{"r", 
     RowBox[{"(", 
      RowBox[{"1", "-", "r"}], ")"}]}], "+", "r"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"In", " ", "general"}], ",", " ", 
    RowBox[{
    "if", " ", "we", " ", "add", " ", "an", " ", "extra", " ", "generation", 
     " ", "of", " ", "intercrossing"}], ",", " ", 
    RowBox[{
     RowBox[{"this", " ", "becomes", " ", "\[IndentingNewLine]", "AA"}], " ", 
     "=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"AA", "'"}], "*", 
        RowBox[{"AA", "'"}]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"AA", "'"}], "*", "7", "*", 
        RowBox[{"AA", "'"}], "*", 
        FractionBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "r"}], ")"}], "2"]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"AA", "'"}], "*", "2", "*", 
        RowBox[{"AB", "'"}], "*", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"(", 
            RowBox[{"1", "-", "r"}], ")"}], "2"], "+", 
          FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"AA", "'"}], "*", "6", "*", 
        RowBox[{"AB", "'"}], "*", 
        FractionBox[
         RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"AA", "'"}], "*", "4", "*", 
        RowBox[{"AC", "'"}], "*", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"(", 
            RowBox[{"1", "-", "r"}], ")"}], "2"], " ", "+", " ", 
          FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"AA", "'"}], "*", "12", "*", 
        RowBox[{"AC", "'"}], "*", 
        FractionBox[
         RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"AA", "'"}], "*", "8", "*", 
        RowBox[{"AE", "'"}], "*", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"(", 
            RowBox[{"1", "-", "r"}], ")"}], "2"], " ", "+", " ", 
          FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
       RowBox[{
        RowBox[{"AA", "'"}], "*", "24", "*", 
        RowBox[{"AE", "'"}], "*", 
        FractionBox[
         RowBox[{"1", "-", "r"}], "2"]}]}], "\[IndentingNewLine]", "=", " ", 
      RowBox[{
       RowBox[{"AA", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"AA", "'"}], " ", "+", " ", 
         RowBox[{"7", "*", 
          RowBox[{"AA", "'"}], "*", 
          FractionBox[
           RowBox[{"(", 
            RowBox[{"1", "-", "r"}], ")"}], "2"]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", 
             RowBox[{"AB", "'"}]}], "+", 
            RowBox[{"4", "*", 
             RowBox[{"AC", "'"}]}], "+", 
            RowBox[{"8", "*", 
             RowBox[{"AE", "'"}]}]}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"(", 
              RowBox[{"1", "-", "r"}], ")"}], "2"], " ", "+", " ", 
            FractionBox["r", "2"]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", "*", 
             RowBox[{"AB", "'"}]}], "+", 
            RowBox[{"12", "*", 
             RowBox[{"AC", "'"}]}], " ", "+", " ", 
            RowBox[{"24", "*", 
             RowBox[{"AE", "'"}]}]}], ")"}], "*", 
          FractionBox[
           RowBox[{"1", "-", "r"}], "2"]}]}]}]}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"AB", " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"AB", "'"}], "*", "2", "*", 
       RowBox[{"AA", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
         FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", "6", "*", 
       RowBox[{"AA", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", 
       RowBox[{"AB", "'"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", "7", "*", 
       RowBox[{"AB", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", "2", "*", 
       RowBox[{"AC", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], " ", "+", 
         FractionBox["r", "2"]}], ")"}]}], "+", " ", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", "12", "*", 
       RowBox[{"AC", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", "2", "*", 
       RowBox[{"AC", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
         FractionBox["r", "2"]}], ")"}]}], " ", "+", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", "8", "*", 
       RowBox[{"AE", "'"}], 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], " ", "+", 
         FractionBox["r", "2"]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"AB", "'"}], "*", "24", "*", 
       RowBox[{"AE", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}]}], "\[IndentingNewLine]", "=", " ", 
     RowBox[{
      RowBox[{"AB", "'"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", 
            RowBox[{"AA", "'"}]}], " ", "+", " ", 
           RowBox[{"4", 
            RowBox[{"AC", "'"}]}], "+", 
           RowBox[{"8", "*", 
            RowBox[{"AE", "'"}]}]}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], "+", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{"AB", "'"}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", "*", 
            RowBox[{"AA", "'"}]}], " ", "+", " ", 
           RowBox[{"7", "*", 
            RowBox[{"AB", "'"}]}], " ", "+", " ", 
           RowBox[{"12", 
            RowBox[{"AC", "'"}]}], " ", "+", " ", 
           RowBox[{"24", "*", 
            RowBox[{"AE", "'"}]}]}], ")"}], "*", 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}]}], ")"}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"AC", " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"AC", "'"}], "*", "2", "*", 
       RowBox[{"AA", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
         FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", "6", "*", 
       RowBox[{"AA", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", "2", "*", 
       RowBox[{"AB", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], "+", 
         FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", "6", "*", 
       RowBox[{"AB", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", 
       RowBox[{"AC", "'"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", "2", "*", 
       RowBox[{"AC", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], "+", 
         FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", "13", "*", 
       RowBox[{"AC", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}], "+", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", "8", "*", 
       RowBox[{"AE", "'"}], "*", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"], "+", 
         FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
      RowBox[{
       RowBox[{"AC", "'"}], "*", "24", "*", 
       RowBox[{"AE", "'"}], "*", 
       FractionBox[
        RowBox[{"1", "-", "r"}], "2"]}]}], "\[IndentingNewLine]", "=", " ", 
     RowBox[{
      RowBox[{"AC", "'"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", 
            RowBox[{"AA", "'"}]}], "+", 
           RowBox[{"2", 
            RowBox[{"AB", "'"}]}], "+", 
           RowBox[{"2", 
            RowBox[{"AC", "'"}]}], "+", 
           RowBox[{"8", 
            RowBox[{"AE", "'"}]}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", "*", 
            RowBox[{"AA", "'"}]}], " ", "+", " ", 
           RowBox[{"6", "*", 
            RowBox[{"AB", "'"}]}], " ", "+", " ", 
           RowBox[{"13", "*", 
            RowBox[{"AC", "'"}]}], "+", 
           RowBox[{"24", "*", 
            RowBox[{"AE", "'"}]}]}], ")"}], "*", 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
        RowBox[{"AC", "'"}]}], ")"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"AE", " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"AE", "'"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"AA", "'"}], "*", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{"6", "*", 
         RowBox[{"AA", "'"}], "*", 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
        RowBox[{"2", "*", 
         RowBox[{"AB", "'"}], "*", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{"6", "*", 
         RowBox[{"AB", "'"}], "*", 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
        RowBox[{"4", "*", 
         RowBox[{"AC", "'"}], "*", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{"12", "*", 
         RowBox[{"AC", "'"}], "*", 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
        RowBox[{"AE", "'"}], " ", "+", " ", 
        RowBox[{"7", "*", 
         RowBox[{"AE", "'"}], "*", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{"24", "*", 
         RowBox[{"AE", "'"}], "*", 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}]}], ")"}]}], "\[IndentingNewLine]", 
     "=", " ", 
     RowBox[{
      RowBox[{"AE", "'"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", 
            RowBox[{"AA", "'"}]}], " ", "+", " ", 
           RowBox[{"2", "*", 
            RowBox[{"AB", "'"}]}], " ", "+", " ", 
           RowBox[{"4", "*", 
            RowBox[{"AC", "'"}]}], " ", "+", " ", 
           RowBox[{"7", "*", 
            RowBox[{"AE", "'"}]}]}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", "*", 
            RowBox[{"AA", "'"}]}], " ", "+", " ", 
           RowBox[{"6", "*", 
            RowBox[{"AB", "'"}]}], " ", "+", " ", 
           RowBox[{"12", " ", "*", " ", 
            RowBox[{"AC", "'"}]}], " ", "+", " ", 
           RowBox[{"24", "*", 
            RowBox[{"AE", "'"}]}]}], ")"}], "*", 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
        RowBox[{"AE", "'"}]}], ")"}]}]}]}], "*)"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"AA_", ",", " ", "AB_", ",", " ", "AC_", ",", " ", "AE_"}], "]"}], 
  ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"AA", 
      RowBox[{"(", 
       RowBox[{"AA", " ", "+", " ", 
        RowBox[{"14", "AA", 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "AB"}], " ", "+", " ", 
           RowBox[{"8", "AC"}], " ", "+", " ", 
           RowBox[{"16", " ", "AE"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"12", "AB"}], " ", "+", " ", 
           RowBox[{"24", " ", "AC"}], " ", "+", " ", 
           RowBox[{"48", "AE"}]}], ")"}], 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}]}], ")"}]}], " ", "+", " ", 
     RowBox[{"2", "*", "AB", "*", "AB", " ", 
      FractionBox["r", "2"]}], "+", " ", 
     RowBox[{"8", "*", "AB", "*", "AC", " ", 
      FractionBox["r", "2"]}], "+", " ", 
     RowBox[{"8", "*", "AC", "*", "AC", " ", 
      FractionBox["r", "2"]}], "+", 
     RowBox[{"16", "*", "AB", "*", "AE", " ", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"32", "*", "AC", "*", "AE", " ", 
      FractionBox["r", "2"]}], "+", " ", 
     RowBox[{"32", "*", "AE", "*", "AE", " ", 
      FractionBox["r", "2"]}]}], ",", 
    RowBox[{
     RowBox[{"AB", 
      RowBox[{"(", 
       RowBox[{"AB", " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "AA"}], "+", " ", 
           RowBox[{"8", " ", "AC"}], "+", 
           RowBox[{"16", "AE"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"12", " ", "AA"}], " ", "+", " ", 
           RowBox[{"14", " ", "AB"}], " ", "+", " ", 
           RowBox[{"24", " ", "AC"}], "+", 
           RowBox[{"48", "AE"}]}], ")"}], 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}]}], ")"}]}], "+", " ", 
     RowBox[{"8", " ", "AC", "*", "AC", "*", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"8", "AA", " ", "*", "AC", " ", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"2", "*", "AA", "*", "AA", " ", 
      FractionBox["r", "2"]}], "+", 
     RowBox[{"16", "AE", "*", "AA", " ", 
      FractionBox["r", "2"]}], "+", " ", 
     RowBox[{"32", "AE", "*", "AC", " ", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"32", "AE", "*", "AE", " ", 
      FractionBox["r", "2"]}]}], ",", " ", 
    RowBox[{
     RowBox[{"AC", 
      RowBox[{"(", 
       RowBox[{"AC", " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", "AA"}], " ", "+", " ", 
           RowBox[{"4", "AB"}], " ", "+", 
           RowBox[{"4", " ", "AC"}], "+", 
           RowBox[{"16", "AE"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"12", " ", "AA"}], " ", "+", " ", 
           RowBox[{"12", " ", "AB"}], " ", "+", " ", 
           RowBox[{"26", " ", "AC"}], " ", "+", " ", 
           RowBox[{"48", " ", "AE"}]}], ")"}], 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}]}], ")"}]}], " ", "+", " ", 
     RowBox[{"2", "AB", "*", "AB", " ", 
      FractionBox["r", "2"]}], "+", 
     RowBox[{"4", "*", "AA", "*", "AB", " ", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"2", "AA", "*", "AA", " ", 
      FractionBox["r", "2"]}], " ", "+", 
     RowBox[{"2", "*", "AC", "*", "AC", "*", 
      FractionBox["r", "2"]}], "+", 
     RowBox[{"4", "*", "AC", "*", 
      RowBox[{"(", 
       RowBox[{"AA", "+", "AB"}], ")"}], "*", 
      FractionBox["r", "2"]}], " ", "+", 
     RowBox[{"16", "AE", "*", "AA", " ", 
      FractionBox["r", "2"]}], "+", " ", 
     RowBox[{"16", "AE", "*", "AB", " ", 
      FractionBox["r", "2"]}], "+", " ", 
     RowBox[{"16", "*", "AE", "*", "AC", " ", 
      FractionBox["r", "2"]}], "+", 
     RowBox[{"32", "AE", "*", "AE", " ", 
      FractionBox["r", "2"]}]}], ",", 
    RowBox[{
     RowBox[{"AE", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "AA"}], " ", "+", " ", 
           RowBox[{"4", " ", "AB"}], " ", "+", " ", 
           RowBox[{"8", " ", "AC"}], " ", "+", " ", 
           RowBox[{"12", "AE"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", "r"}], "2"], " ", "+", " ", 
           FractionBox["r", "2"]}], ")"}]}], " ", "+", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"12", " ", "AA"}], " ", "+", " ", 
           RowBox[{"12", " ", "AB"}], " ", "+", " ", 
           RowBox[{"24", " ", "AC"}], " ", "+", " ", 
           RowBox[{"50", " ", "AE"}]}], ")"}], 
         FractionBox[
          RowBox[{"1", "-", "r"}], "2"]}], "+", "AE"}], ")"}]}], "+", 
     RowBox[{"2", "*", "AA", "*", "AA", " ", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"4", "AA", "*", "AB", "*", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"8", "AA", "*", "AC", " ", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"2", "AB", "*", "AB", " ", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"8", " ", "AB", "*", "AC", " ", 
      FractionBox["r", "2"]}], " ", "+", " ", 
     RowBox[{"8", "*", "AC", "*", "AC", " ", 
      FractionBox["r", "2"]}], "+", 
     RowBox[{"12", "*", "AE", "*", "AA", " ", 
      FractionBox["r", "2"]}], "+", 
     RowBox[{"12", "*", "AE", "*", "AB", " ", 
      FractionBox["r", "2"]}], "+", 
     RowBox[{"24", "*", "AE", "*", "AC", " ", 
      FractionBox["r", "2"]}], "+", " ", 
     RowBox[{"18", "*", "AE", "*", "AE", " ", 
      FractionBox["r", "2"]}]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"r_", ",", " ", "n_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "64"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], "n"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "r"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"7", "-", 
        RowBox[{"10", " ", "r"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["r", "2"]}]}], ")"}]}], " ", "+", " ", 
     FractionBox["1", "64"]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["1", "64"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], "n"], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "r"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"6", " ", "r"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
     FractionBox["1", "64"]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "64"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], "n"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "r"}]}], ")"}], "2"]}], " ", "+", " ", 
     FractionBox["1", "64"]}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "64"]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], "n"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "r"}]}], ")"}], "1"]}], " ", "+", " ", 
     FractionBox["1", "64"]}]}], "}"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"r", ",", " ", "3"}], "]"}], " ", "-", " ", 
   RowBox[{"f", " ", "@@", 
    RowBox[{"(", 
     RowBox[{"f", " ", "@@", 
      RowBox[{"(", 
       RowBox[{"f", "[", 
        RowBox[{
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", "r"}], ")"}], "3"], "8"], ",", 
         FractionBox[
          RowBox[{"r", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], "2"]}], "8"], ",", 
         FractionBox[
          RowBox[{"r", 
           RowBox[{"(", 
            RowBox[{"1", "-", "r"}], ")"}]}], "16"], ",", 
         FractionBox["r", "32"]}], "]"}], ")"}]}], ")"}]}]}], "//", 
  "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"r", ",", " ", "2"}], "]"}], " ", "-", " ", 
   RowBox[{"(", 
    RowBox[{"f", " ", "@@", 
     RowBox[{"(", 
      RowBox[{"f", "[", 
       RowBox[{
        FractionBox[
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}], "3"], "8"], ",", 
        FractionBox[
         RowBox[{"r", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", "r"}], ")"}], "2"]}], "8"], ",", 
        FractionBox[
         RowBox[{"r", 
          RowBox[{"(", 
           RowBox[{"1", "-", "r"}], ")"}]}], "16"], ",", 
        FractionBox["r", "32"]}], "]"}], ")"}]}], ")"}]}], "//", 
  "Simplify"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"haplotypeProbFunc", "[", 
   RowBox[{"first_", ",", " ", "second_", ",", " ", "nIntercrossing_"}], 
   "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "afterIntercrossingAA", ",", " ", "afterIntercrossingAB", ",", " ", 
      "afterIntercrossingAC", ",", " ", "afterIntercrossingAE"}], "}"}], ",", 
    "\[IndentingNewLine]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "afterIntercrossingAA", ",", " ", "afterIntercrossingAB", ",", " ", 
        "afterIntercrossingAC", ",", " ", "afterIntercrossingAE"}], "}"}], 
      "=", " ", 
      RowBox[{"g", "[", 
       RowBox[{"r", ",", " ", "nIntercrossing"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"first", " ", "\[Equal]", " ", "second"}], ",", " ", 
       "afterIntercrossingAA", ",", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"startRelevant2", "[", "first", "]"}], " ", "\[Equal]", " ", 
          RowBox[{"startRelevant2", "[", "second", "]"}]}], ",", " ", 
         "afterIntercrossingAB", ",", " ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"startRelevant4", "[", "first", "]"}], " ", "\[Equal]", 
            " ", 
            RowBox[{"startRelevant4", "[", "second", "]"}]}], ",", " ", 
           "afterIntercrossingAC", ",", " ", "afterIntercrossingAE"}], 
          "]"}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"initialProb", "[", 
   RowBox[{"r_", ",", " ", "nIntercrossing_"}], "]"}], " ", ":=", " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"haplotypeProbFunc", "[", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", " ", "nIntercrossing"}], 
         "]"}], "*", 
        RowBox[{"haplotypeProbFunc", "[", 
         RowBox[{
          RowBox[{"#1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
          RowBox[{"#1", "[", 
           RowBox[{"[", "4", "]"}], "]"}], ",", " ", "nIntercrossing"}], 
         "]"}]}], ")"}], "&"}], " ", "/@", " ", "states"}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"#1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "&"}], " ", "/@", "statesWithCounts"}],
     ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"initialProbZero", " ", "=", " ", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", " ", 
     RowBox[{"Length", "[", "states", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initialProbZero", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"Position", "[", 
        RowBox[{"states", ",", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5", ",", "1", ",", "5"}], "}"}]}], "]"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "=", " ", 
   RowBox[{
    FractionBox["1", "2"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", "r"}], ")"}], "4"], "16"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initialProbZero", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"Position", "[", 
        RowBox[{"states", ",", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5", ",", "1", ",", "6"}], "}"}]}], "]"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "=", " ", 
   RowBox[{
    FractionBox["1", "2"], 
    FractionBox[
     RowBox[{"r", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], "3"]}], "16"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initialProbZero", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"Position", "[", 
        RowBox[{"states", ",", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5", ",", "1", ",", "7"}], "}"}]}], "]"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "=", " ", 
   RowBox[{
    FractionBox["1", "2"], 
    FractionBox[
     RowBox[{"r", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], "2"]}], "32"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initialProbZero", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"Position", "[", 
        RowBox[{"states", ",", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5", ",", "2", ",", "6"}], "}"}]}], "]"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "=", 
   RowBox[{
    FractionBox["1", "2"], 
    FractionBox[
     RowBox[{
      SuperscriptBox["r", "2"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "r"}], ")"}], "2"]}], "16"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initialProbZero", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"Position", "[", 
        RowBox[{"states", ",", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5", ",", "2", ",", "7"}], "}"}]}], "]"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "=", 
   RowBox[{
    FractionBox["1", "2"], 
    FractionBox[
     RowBox[{
      SuperscriptBox["r", "2"], 
      RowBox[{"(", 
       RowBox[{"1", "-", "r"}], ")"}]}], "32"]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"initialProbZero", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{"Position", "[", 
        RowBox[{"states", ",", " ", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5", ",", "3", ",", "7"}], "}"}]}], "]"}], "]"}], 
      "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "=", " ", 
   RowBox[{
    FractionBox["1", "2"], 
    FractionBox[
     SuperscriptBox["r", "2"], "64"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"initialProb", "[", 
   RowBox[{"r", ",", " ", "0"}], "]"}], " ", ":=", " ", 
  RowBox[{"initialProbZero", "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"#1", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "&"}], " ", "/@", "statesWithCounts"}],
     ")"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plus", "@@", 
   RowBox[{"initialProb", "[", 
    RowBox[{"r", ",", " ", "1"}], "]"}]}], "//", "Simplify"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"combinedProbabilities", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"initialProb", "[", 
       RowBox[{"r", ",", " ", "nIntercrossing"}], "]"}], ".", "power"}], 
     ")"}], "//", "FullSimplify"}]}], ";"}]], "Input"],

Cell[BoxData[
 RowBox[{"selfingLimit", " ", "=", " ", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{"combinedProbabilities", ",", " ", 
     RowBox[{"d", "\[Rule]", " ", "\[Infinity]"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"0", " ", "<", " ", "r", " ", "<", " ", 
       RowBox[{"1", "/", "2"}]}]}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"selfingLimit", "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "&"}], " ", "/@", "statesWithCounts"}], 
   ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Divide", " ", "by", " ", "the", " ", "numbers", " ", "of", " ", 
    "states"}], ",", " ", 
   RowBox[{"because", " ", 
    RowBox[{"they", "'"}], "ve", " ", "been", " ", "aggregated"}]}], 
  "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{"noIntercrossingLimit", " ", "=", " ", 
  RowBox[{
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"initialProb", "[", 
         RowBox[{"r", ",", " ", "0"}], "]"}], ".", "power"}], ")"}], "//", 
      "FullSimplify"}], ",", " ", 
     RowBox[{"d", "\[Rule]", " ", "\[Infinity]"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"0", " ", "<", " ", "r", " ", "<", " ", 
       RowBox[{"1", "/", "2"}]}]}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"noIntercrossingLimit", "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "&"}], " ", "/@", "statesWithCounts"}], 
   ")"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Rewrite", " ", "the", " ", "formula", " ", "into", " ", "something", " ", 
   "computable", " ", "more", " ", 
   RowBox[{"efficiently", ".", " ", "The"}], " ", "must", " ", "general", " ",
    "case", " ", "first"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"combinedProbabilities", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}], 
             RowBox[{"-", "1"}]], " ", "\[Rule]", " ", "onePlus2RInverse"}], 
           ",", " ", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", "r"}], ")"}], "nIntercrossing"], " ", 
            "\[Rule]", " ", "powOneMinusR1"}], ",", " ", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", "r"}], ")"}], 
             RowBox[{"2", " ", "nIntercrossing"}]], " ", "\[Rule]", " ", 
            "powOneMinusR2"}], ",", " ", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", "r"}], ")"}], 
             RowBox[{"1", "+", "nIntercrossing"}]], "\[Rule]", " ", 
            RowBox[{"powOneMinusR1", " ", "oneMinusR"}]}], ",", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", "r"}], ")"}], 
             RowBox[{"2", "+", "nIntercrossing"}]], "\[Rule]", " ", 
            RowBox[{"powOneMinusR1", " ", "oneMinusRSquared"}]}], ",", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "r"}], ")"}], " ", "\[Rule]", " ", 
            "oneMinusR"}], ",", " ", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"2", " ", "r"}]}], ")"}], "d"], "\[Rule]", " ", 
            "powOneMinus2R1"}], ",", " ", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"2", " ", "r"}]}], ")"}], 
             RowBox[{"1", "+", "d"}]], "\[Rule]", " ", 
            RowBox[{"powOneMinus2R1", " ", "oneMinus2R"}]}], ",", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}], "\[Rule]", " ", "onePlus2R"}],
            ",", " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "r"}], ")"}], " ", "r"}]}], ")"}], 
            "\[Rule]", " ", "quadratic1"}], ",", " ", 
           RowBox[{
            RowBox[{"1", "-", 
             RowBox[{"6", "r"}], "+", 
             RowBox[{"4", 
              SuperscriptBox["r", "2"]}]}], " ", "\[Rule]", " ", 
            "quadratic2"}], ",", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"7", "+", 
               RowBox[{"2", "r", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "5"}], "+", 
                  RowBox[{"2", "r"}]}], ")"}]}]}], ")"}], "2"], "\[Rule]", 
            " ", "quadratic3Squared"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"7", "+", 
              RowBox[{"2", "r", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "5"}], "+", 
                 RowBox[{"2", "r"}]}], ")"}]}]}], ")"}], "\[Rule]", " ", 
            "quadratic3"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"2", " ", "r"}]}], ")"}], " ", "\[Rule]", " ", 
            RowBox[{"-", "oneMinus2R"}]}], ",", " ", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"2", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "r"}], ")"}], "r"}]}], ")"}], "d"],
             "\[Rule]", " ", "complex1"}], ",", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"8", "r"}], "-", 
               RowBox[{"16", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"8", 
                SuperscriptBox["r", "3"]}]}], ")"}], "2"], "\[Rule]", " ", 
            "complex2"}], ",", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "16"}], "r", 
             RowBox[{"(", 
              RowBox[{"5", "+", 
               RowBox[{"r", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "5"}], "+", 
                  RowBox[{"2", "r"}]}], ")"}]}]}], ")"}]}], "\[Rule]", " ", 
            "complex3"}]}], "}"}]}], ")"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"complex1", "+", "powOneMinus2R1"}], ")"}], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              RowBox[{"powOneMinusR1", 
               RowBox[{"(", 
                RowBox[{"1", "-", 
                 RowBox[{"2", "r"}]}], ")"}]}]}], ")"}], "2"]}], "\[Rule]", 
          " ", "complex4"}], ",", 
         RowBox[{
          RowBox[{"complex1", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"oneMinus2R", " ", "powOneMinusR1"}]}], ")"}], "2"]}], 
          "\[Rule]", " ", "complex5"}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"7", "-", 
            RowBox[{"8", "r", 
             RowBox[{"(", 
              RowBox[{"3", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "+", "r"}], ")"}], "r"}]}], ")"}]}]}], 
           ")"}], "\[Rule]", " ", "complex6"}], ",", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "r"}], ")"}], "r"}]}], ")"}], 
          "\[Rule]", " ", "complex7"}], ",", 
         RowBox[{
          RowBox[{"r", 
           RowBox[{"(", 
            RowBox[{"11", "+", 
             RowBox[{"4", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "3"}], "+", "r"}], ")"}], "r"}]}], ")"}]}], 
          "\[Rule]", " ", "complex8"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "r"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "3"}], "+", 
             RowBox[{"2", "r"}]}], ")"}]}], "\[Rule]", " ", "complex9"}], ",",
          " ", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "powOneMinusR1", "-", 
             RowBox[{
             "8", "oneMinusRSquared", " ", "powOneMinusR1", " ", "r"}]}], 
            ")"}], "2"], "\[Rule]", " ", "complex10"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "powOneMinusR1", "+", 
            RowBox[{
            "8", "oneMinusRSquared", " ", "powOneMinusR1", " ", "r"}]}], 
           ")"}], "\[Rule]", " ", "complex11"}]}], "}"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "3"}], "-", "d"}]], "\[Rule]", " ", 
         FractionBox["1", 
          RowBox[{
           SuperscriptBox["2", "3"], "pow2"}]]}], ",", " ", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "4"}], "-", "d"}]], " ", "\[Rule]", " ", 
         FractionBox["1", 
          RowBox[{
           SuperscriptBox["2", "4"], "pow2"}]]}], ",", " ", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "5"}], "-", "d"}]], "\[Rule]", " ", 
         FractionBox["1", 
          RowBox[{
           SuperscriptBox["2", "5"], "pow2"}]]}], " ", ",", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "6"}], "-", "d"}]], "\[Rule]", " ", 
         FractionBox["1", 
          RowBox[{
           SuperscriptBox["2", "6"], "pow2"}]]}], ",", " ", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "7"}], "-", "d"}]], "\[Rule]", " ", 
         FractionBox["1", 
          RowBox[{
           SuperscriptBox["2", "7"], "pow2"}]]}], ",", " ", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "8"}], "-", "d"}]], "\[Rule]", " ", 
         FractionBox["1", 
          RowBox[{
           SuperscriptBox["2", "8"], "pow2"}]]}], ",", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "9"}], "-", "d"}]], "\[Rule]", " ", 
         FractionBox["1", 
          RowBox[{
           SuperscriptBox["2", "9"], "pow2"}]]}], ",", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "10"}], "-", "d"}]], "\[Rule]", " ", 
         FractionBox["1", 
          RowBox[{
           SuperscriptBox["2", "10"], "pow2"}]]}], ",", " ", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"1", "+", "d"}]], " ", "\[Rule]", " ", 
         RowBox[{"2", " ", "pow2"}]}], ",", " ", 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"2", "+", "d"}]], " ", "\[Rule]", " ", 
         RowBox[{"4", " ", "pow2"}]}], ",", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "r"}]}], ")"}], "3"], "\[Rule]", " ", 
         "oneMinus2RCubed"}], ",", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", "r"}]}], ")"}], "4"], "\[Rule]", " ", 
         "oneMinus2RPow4"}]}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "r"}]}], ")"}], "2"], "\[Rule]", " ", 
        "oneMinus2RSquared"}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"oneMinus2RSquared", " ", "powOneMinusR1"}]}], ")"}], "2"],
         "\[Rule]", " ", "complex12"}], ",", " ", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"powOneMinusR1", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"2", "r"}]}], ")"}]}]}], ")"}], "2"], "\[Rule]", " ", 
        "complex13"}]}], "}"}]}], "/.", 
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"complex13", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "complex1"}], "+", "powOneMinus2R1"}], ")"}]}], 
         ")"}]}], "\[Rule]", " ", "complex14"}], ",", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "r"}], ")"}], "r"}]}], ")"}], "\[Rule]", 
       " ", "complex15"}], ",", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"4", " ", "pow2"}], "-", 
         RowBox[{"2", "oneMinus2R", " ", "powOneMinus2R1"}], "-", 
         RowBox[{"6", "r"}]}], ")"}], "\[Rule]", " ", "complex16"}], ",", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"oneMinus2RSquared", " ", "powOneMinusR1"}]}], ")"}], "2"], 
       "\[Rule]", " ", "complex17"}], ",", " ", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          RowBox[{"oneMinus2R", " ", "powOneMinusR1", " ", "quadratic3"}]}], 
         ")"}], "2"], "\[Rule]", " ", "complex18"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"complex1", "-", "powOneMinus2R1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"complex6", " ", "powOneMinusR1"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"oneMinus2RSquared", " ", "powOneMinusR1"}]}], ")"}]}], 
       "\[Rule]", " ", "complex19"}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"oneMinus2R", " ", "powOneMinusR1"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"8", "+", 
          RowBox[{"complex1", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "7"}], "-", 
             RowBox[{"oneMinus2R", " ", "powOneMinusR1"}]}], ")"}]}]}], 
         ")"}]}], "\[Rule]", " ", "complex20"}]}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "7"}], "+", 
        RowBox[{"6", "complex15", " ", "oneMinus2R", " ", "powOneMinusR1"}], 
        "+", 
        RowBox[{
         SuperscriptBox["oneMinus2R", "3"], "powOneMinusR2", " ", 
         "quadratic2"}]}], ")"}], "\[Rule]", " ", "complex21"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"complex4", "+", 
        RowBox[{"complex10", 
         RowBox[{"(", 
          RowBox[{"complex1", "-", "powOneMinus2R1"}], ")"}]}]}], ")"}], 
      "\[Rule]", " ", "complex22"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"8", "-", 
        RowBox[{
        "8", "oneMinus2RSquared", " ", "oneMinusR", " ", "powOneMinusR1"}], 
        "+", 
        RowBox[{"complex1", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "7"}], "+", 
           RowBox[{
           "6", "oneMinus2RSquared", " ", "oneMinusR", " ", "powOneMinusR1"}],
            "+", 
           RowBox[{
           "oneMinus2RSquared", " ", "powOneMinusR2", " ", "quadratic2"}]}], 
          ")"}]}]}], ")"}], "\[Rule]", " ", "complex23"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "7"}], "+", 
        RowBox[{"6", "oneMinus2R", " ", "oneMinusR", " ", "powOneMinusR1"}], 
        "+", 
        RowBox[{
         SuperscriptBox["oneMinus2R", "3"], "powOneMinusR2"}]}], ")"}], 
      "\[Rule]", " ", "complex24"}], ",", 
     RowBox[{
      RowBox[{"complex1", "-", "powOneMinus2R1"}], "\[Rule]", " ", 
      "complex25"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"oneMinus2RSquared", " ", "powOneMinusR1"}]}], ")"}], 
      "\[Rule]", " ", "complex26"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"complex6", " ", "powOneMinusR1"}]}], ")"}], "\[Rule]", " ", 
      "complex27"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
        "2", "oneMinus2R", " ", "oneMinusRSquared", " ", "powOneMinusR1"}], 
        "-", 
        RowBox[{
        "complex7", " ", "oneMinus2RSquared", " ", "powOneMinusR2"}]}], ")"}],
       "\[Rule]", " ", "complex28"}], ",", 
     RowBox[{
      RowBox[{
      "oneMinus2R", " ", "oneMinusR", " ", "powOneMinus2R1", " ", 
       "powOneMinusR1", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"oneMinus2R", " ", "powOneMinusR1"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "r"}], ")"}]}], "\[Rule]", " ", 
      "complex29"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"49", "+", 
        RowBox[{"complex2", " ", "powOneMinusR2"}], "-", 
        RowBox[{
        "18", "oneMinus2R", " ", "powOneMinusR1", " ", "quadratic2"}]}], 
       ")"}], "\[Rule]", " ", "complex30"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"49", "-", 
        RowBox[{"18", "oneMinus2R", " ", "powOneMinusR1"}], "+", 
        RowBox[{"oneMinus2RSquared", " ", "powOneMinusR2"}]}], ")"}], 
      "\[Rule]", " ", "complex31"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"onePlus2R", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "7"}], "+", 
           RowBox[{"4", "pow2"}]}], ")"}]}], "-", 
        RowBox[{"complex16", " ", "oneMinus2R", " ", "powOneMinusR1"}]}], 
       ")"}], "\[Rule]", " ", "complex32"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"onePlus2R", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"4", "pow2"}]}], ")"}]}], "-", 
       RowBox[{
       "complex16", " ", "oneMinus2R", " ", "powOneMinusR1", " ", 
        "quadratic2"}]}], "\[Rule]", " ", "complex33"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", "oneMinus2R", " ", "powOneMinusR1"}], "+", 
        RowBox[{
         SuperscriptBox["oneMinus2R", "3"], "powOneMinusR2", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"2", "r"}]}], ")"}]}]}], ")"}], "\[Rule]", " ", 
      "complex34"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
        "2", "oneMinus2R", " ", "oneMinusRSquared", " ", "powOneMinusR1"}], 
        "+", 
        RowBox[{
        "complex15", " ", "oneMinus2RSquared", " ", "powOneMinusR2"}]}], 
       ")"}], "\[Rule]", " ", "complex35"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "7"}], "+", 
        RowBox[{"4", "*", "pow2"}]}], ")"}], "\[Rule]", " ", "complex36"}], 
     ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"oneMinus2R", "*", "powOneMinusR1"}]}], ")"}], "\[Rule]", " ",
       "complex37"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
        "2", "*", "oneMinus2R", "*", "oneMinusR", "*", "powOneMinusR1"}], "+", 
        RowBox[{"oneMinus2RSquared", "*", "powOneMinusR2", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"2", "*", "r"}]}], ")"}]}]}], ")"}], "\[Rule]", " ", 
      "complex38"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"complex1", "+", "powOneMinus2R1"}], ")"}], "\[Rule]", " ", 
      "complex39"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"oneMinus2RSquared", "*", "powOneMinusR1"}]}], ")"}], 
      "\[Rule]", " ", "complex40"}]}], "}"}]}], "//", "InputForm"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"noIntercrossing", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"initialProb", "[", 
       RowBox[{"r", ",", " ", "0"}], "]"}], ".", "power"}], ")"}], "//", 
    "FullSimplify"}]}], ";"}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"rewritten", " ", "=", " ", 
   RowBox[{
    RowBox[{"noIntercrossing", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"1", "-", "d"}]], "\[Rule]", " ", 
        FractionBox["2", "pow2"]}], ",", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "1"}], "-", "d"}]], "\[Rule]", " ", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["2", "1"], "pow2"}]]}], ",", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "2"}], "-", "d"}]], "\[Rule]", " ", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["2", "2"], "pow2"}]]}], ",", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "3"}], "-", "d"}]], "\[Rule]", " ", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["2", "3"], "pow2"}]]}], ",", " ", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "4"}], "-", "d"}]], " ", "\[Rule]", " ", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["2", "4"], "pow2"}]]}], ",", " ", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "5"}], "-", "d"}]], "\[Rule]", " ", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["2", "5"], "pow2"}]]}], " ", ",", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "6"}], "-", "d"}]], "\[Rule]", " ", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["2", "6"], "pow2"}]]}], ",", " ", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "7"}], "-", "d"}]], "\[Rule]", " ", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["2", "7"], "pow2"}]]}], ",", " ", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "8"}], "-", "d"}]], "\[Rule]", " ", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["2", "8"], "pow2"}]]}], ",", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "9"}], "-", "d"}]], "\[Rule]", " ", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["2", "9"], "pow2"}]]}], ",", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "10"}], "-", "d"}]], "\[Rule]", " ", 
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["2", "10"], "pow2"}]]}], ",", " ", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"1", "+", "d"}]], " ", "\[Rule]", " ", 
        RowBox[{"2", " ", "pow2"}]}], ",", " ", 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"2", "+", "d"}]], " ", "\[Rule]", " ", 
        RowBox[{"4", " ", "pow2"}]}], ",", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "r"}]}], ")"}], "d"], "\[Rule]", " ", 
        "powOneMinus2R1"}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "r"}], ")"}], "^", "2"}], "\[Rule]", " ", 
        "rMinus1Squared"}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "r"}], ")"}], "*", "r"}]}], ")"}], "^",
          "d"}], "\[Rule]", " ", "complex1"}], ",", " ", 
       RowBox[{
        RowBox[{"r", "^", "2"}], "\[Rule]", " ", "rSquared"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", "*", "r"}]}], ")"}], "\[Rule]", " ", "onePlus2R"}]}], 
      "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SuperscriptBox["2", "d"], "\[Rule]", " ", "pow2"}], ",", " ", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"-", "d"}]], "\[Rule]", " ", 
       FractionBox["1", "pow2"]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "r"}], ")"}], "^", "4"}], "\[Rule]", " ", 
       "rMinus1Pow4"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "r"}], ")"}], "^", "3"}], "\[Rule]", " ", 
       "rMinus1Pow3"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"InputForm", "[", "rewritten", "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"contributionsToMarkerValue", "[", 
   RowBox[{
   "marker1Pattern_", ",", " ", "marker2Pattern_", ",", " ", 
    "markerAllele11_", ",", "markerAllele12_", " ", ",", "markerAllele21_", 
    ",", " ", "markerAllele22_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"state", ",", " ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"marker1Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele11"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker1Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele12"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker2Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele21"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker2Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "]"}], " ", "]"}], "\[Equal]", 
         " ", "markerAllele22"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"permuted", ",", "position"}], "}"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"permuted", " ", "=", " ", 
           RowBox[{"DeleteDuplicates", "[", 
            RowBox[{"allPermutations", "[", "state", "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"position", " ", "=", " ", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
             "permuted"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"combinedProbabilities", "[", 
            RowBox[{"[", 
             RowBox[{"position", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "/", 
           RowBox[{
            RowBox[{"statesWithCounts", "[", 
             RowBox[{"[", 
              RowBox[{"position", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", "0"}], "]"}]}], "]"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"1", ",", " ", "8"}], "]"}], ",", " ", "4"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"contributionsToMarkerValueNoIntercross", "[", 
   RowBox[{
   "marker1Pattern_", ",", " ", "marker2Pattern_", ",", " ", 
    "markerAllele11_", ",", "markerAllele12_", " ", ",", "markerAllele21_", 
    ",", " ", "markerAllele22_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"state", ",", " ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"marker1Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele11"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker1Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele12"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker2Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "]"}], " ", "\[Equal]", 
         " ", "markerAllele21"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"marker2Pattern", "[", 
          RowBox[{"[", 
           RowBox[{"state", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "]"}], " ", "]"}], "\[Equal]", 
         " ", "markerAllele22"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"permuted", ",", "position"}], "}"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"permuted", " ", "=", " ", 
           RowBox[{"DeleteDuplicates", "[", 
            RowBox[{"allPermutations", "[", "state", "]"}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"position", " ", "=", " ", 
           RowBox[{"Flatten", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Position", "[", 
               RowBox[{"states", ",", "#1"}], "]"}], "&"}], "/@", 
             "permuted"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"expected8wayFiniteSelfing", "[", 
            RowBox[{"[", 
             RowBox[{"position", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "/", 
           RowBox[{
            RowBox[{"statesWithCounts", "[", 
             RowBox[{"[", 
              RowBox[{"position", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}]}], "\[IndentingNewLine]", 
        "]"}], ",", "\[IndentingNewLine]", "0"}], "]"}]}], "]"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"1", ",", " ", "8"}], "]"}], ",", " ", "4"}], 
    "]"}]}]}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "One", " ", "generation", " ", "of", " ", "intercrossing", " ", "and", " ",
     "zero", " ", "generations", " ", "of", " ", "selfing", " ", "is", " ", 
    "uninformative"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Plus", " ", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contributionsToMarkerValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "0", ",", " ", "0", ",", " ", "1", ",", " ", "1", ",", " ", "0", 
             ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
            "1", ",", "0", ",", " ", "1", ",", " ", "0", ",", " ", "1", ",", 
             " ", "0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", " ", 
           RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"d", "\[Rule]", "0"}], ",", " ", 
           RowBox[{"nIntercrossing", "\[Rule]", "1"}]}], "}"}]}], ")"}]}], "//",
       "Simplify"}], ")"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Zero", " ", "generations", " ", "of", " ", "intercrossing", " ", "and", 
    " ", "zero", " ", "generations", " ", "of", " ", "selfing", " ", "is", 
    " ", "uninformative"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Plus", " ", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contributionsToMarkerValueNoIntercross", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "0", ",", " ", "0", ",", " ", "1", ",", " ", "1", ",", " ", "0", 
             ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
            "1", ",", "0", ",", " ", "1", ",", " ", "0", ",", " ", "1", ",", 
             " ", "0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", " ", 
           RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{"d", "\[Rule]", "0"}], "}"}]}], ")"}]}], "//", "Simplify"}],
      ")"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Zero", " ", "generations", " ", "of", " ", "intercrossing", " ", "and", 
    " ", "one", " ", "generation", " ", "of", " ", "selfing", " ", "is", " ", 
    "informative"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Plus", " ", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contributionsToMarkerValueNoIntercross", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "0", ",", " ", "0", ",", " ", "1", ",", " ", "1", ",", " ", "0", 
             ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
            "1", ",", "0", ",", " ", "1", ",", " ", "0", ",", " ", "1", ",", 
             " ", "0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", " ", 
           RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{"d", "\[Rule]", "1"}], "}"}]}], ")"}]}], "//", "Simplify"}],
      ")"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "One", " ", "generation", " ", "of", " ", "intercrossing", " ", "and", " ",
     "one", " ", "generation", " ", "of", " ", "selfing", " ", "is", " ", 
    "informative"}], "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Plus", " ", "@@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"contributionsToMarkerValue", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "0", ",", " ", "0", ",", " ", "1", ",", " ", "1", ",", " ", "0", 
             ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
            "1", ",", "0", ",", " ", "1", ",", " ", "0", ",", " ", "1", ",", 
             " ", "0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", " ", 
           RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"d", "\[Rule]", "1"}], ",", " ", 
           RowBox[{"nIntercrossing", "\[Rule]", "1"}]}], "}"}]}], ")"}]}], "//",
       "Simplify"}], ")"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], 
    "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Approximately", " ", "uninformative", " ", "case"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"uninformative", " ", "=", " ", 
   RowBox[{"Limit", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Plus", " ", "@@", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"contributionsToMarkerValue", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
               "1", ",", " ", "0", ",", " ", "0", ",", " ", "1", ",", " ", 
                "1", ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
               "0", ",", "0", ",", " ", "1", ",", " ", "0", ",", " ", "0", 
                ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}], ",", 
              " ", 
              RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
            RowBox[{"{", 
             RowBox[{"nIntercrossing", "\[Rule]", "0"}], "}"}]}], ")"}]}], "//",
          "Simplify"}], ")"}], "&"}], "/@", 
      RowBox[{"Tuples", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], "]"}]}], ",", 
     " ", 
     RowBox[{"d", "\[Rule]", " ", "\[Infinity]"}], ",", " ", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"0", " ", "<", " ", "r", " ", "<", " ", 
       RowBox[{"1", "/", "2"}]}]}]}], "]"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tuples", " ", "=", " ", 
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], "]"}]}], "}"}], 
   ",", " ", "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", " ", "=", " ", "1"}], ",", " ", 
     RowBox[{"i", " ", "\[LessEqual]", " ", 
      RowBox[{"Length", "[", "tuples", "]"}]}], ",", " ", 
     RowBox[{"i", "++"}], ",", " ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"UnsameQ", "[", 
        RowBox[{
         RowBox[{"uninformative", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", " ", "0"}], "]"}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Export", "[", 
        RowBox[{
         RowBox[{"\"\<approximatelyFlatSingleFunnel\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"tuples", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "<>", " ", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"tuples", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\<.pdf\>\""}], 
         ",", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"uninformative", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"r", ",", " ", "0", ",", " ", 
             FractionBox["1", "2"]}], "}"}], ",", " ", 
           RowBox[{"AxesLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"r", ",", " ", 
              RowBox[{"\"\<Probability of \>\"", " ", "<>", " ", 
               RowBox[{"ToString", "[", 
                RowBox[{
                 RowBox[{"tuples", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "<>", 
               "\"\<, \>\"", " ", "<>", " ", 
               RowBox[{"ToString", "[", 
                RowBox[{
                 RowBox[{"tuples", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "]"}]}]}], "}"}]}]}], 
          "]"}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], "]"}]}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Symmetric", " ", "case"}], "*)"}]], "Input"],

Cell[BoxData[{
 RowBox[{"uninformative2", " ", "=", " ", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Plus", " ", "@@", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"contributionsToMarkerValue", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "1", ",", " ", "1", ",", " ", "0", ",", " ", "1", ",", " ", "1",
                ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}], ",", 
             " ", 
             RowBox[{"{", 
              RowBox[{
              "0", ",", "1", ",", " ", "1", ",", " ", "0", ",", " ", "0", ",",
                " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
             RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
           RowBox[{"{", 
            RowBox[{"nIntercrossing", "\[Rule]", "0"}], "}"}]}], ")"}]}], "//",
         "Simplify"}], ")"}], "&"}], "/@", 
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], "]"}]}], ",", 
    " ", 
    RowBox[{"d", "\[Rule]", " ", "\[Infinity]"}], ",", " ", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"0", " ", "<", " ", "r", " ", "<", " ", 
      RowBox[{"1", "/", "2"}]}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tuples", " ", "=", " ", 
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], "]"}]}], "}"}], 
   ",", " ", "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", " ", "=", " ", "1"}], ",", " ", 
     RowBox[{"i", " ", "\[LessEqual]", " ", 
      RowBox[{"Length", "[", "tuples", "]"}]}], ",", " ", 
     RowBox[{"i", "++"}], ",", " ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"UnsameQ", "[", 
        RowBox[{
         RowBox[{"uninformative2", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", " ", "0"}], "]"}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Export", "[", 
        RowBox[{
         RowBox[{"\"\<uninformativeSingleFunnel\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"tuples", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "<>", " ", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"tuples", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\<.pdf\>\""}], 
         ",", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"uninformative2", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"r", ",", " ", "0", ",", " ", 
             FractionBox["1", "2"]}], "}"}], ",", " ", 
           RowBox[{"AxesLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"r", ",", " ", 
              RowBox[{"\"\<Probability of \>\"", " ", "<>", " ", 
               RowBox[{"ToString", "[", 
                RowBox[{
                 RowBox[{"tuples", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "<>", 
               "\"\<, \>\"", " ", "<>", " ", 
               RowBox[{"ToString", "[", 
                RowBox[{
                 RowBox[{"tuples", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "]"}]}]}], "}"}]}]}], 
          "]"}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], "]"}]}], 
  "]"}]}], "Input"],

Cell[BoxData[{
 RowBox[{"informative", " ", "=", " ", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Plus", " ", "@@", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"contributionsToMarkerValue", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "1", ",", " ", "1", ",", " ", "0", ",", " ", "1", ",", " ", "1",
                ",", " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}], ",", 
             " ", 
             RowBox[{"{", 
              RowBox[{
              "0", ",", "1", ",", " ", "0", ",", " ", "0", ",", " ", "0", ",",
                " ", "0", ",", " ", "1", ",", " ", "1"}], "}"}], ",", " ", 
             RowBox[{"Sequence", "@@", "#1"}]}], "]"}], "/.", 
           RowBox[{"{", 
            RowBox[{"nIntercrossing", "\[Rule]", "0"}], "}"}]}], ")"}]}], "//",
         "Simplify"}], ")"}], "&"}], "/@", 
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], "]"}]}], ",", 
    " ", 
    RowBox[{"d", "\[Rule]", " ", "\[Infinity]"}], ",", " ", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"0", " ", "<", " ", "r", " ", "<", " ", 
      RowBox[{"1", "/", "2"}]}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"tuples", " ", "=", " ", 
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "1"}], "}"}], ",", " ", "4"}], "]"}]}], "}"}], 
   ",", " ", "\[IndentingNewLine]", 
   RowBox[{"For", "[", 
    RowBox[{
     RowBox[{"i", " ", "=", " ", "1"}], ",", " ", 
     RowBox[{"i", " ", "\[LessEqual]", " ", 
      RowBox[{"Length", "[", "tuples", "]"}]}], ",", " ", 
     RowBox[{"i", "++"}], ",", " ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"UnsameQ", "[", 
        RowBox[{
         RowBox[{"informative", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", " ", "0"}], "]"}], ",", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"Export", "[", 
        RowBox[{
         RowBox[{"\"\<informativeSingleFunnel\>\"", "<>", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"tuples", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "<>", " ", 
          RowBox[{"ToString", "[", 
           RowBox[{
            RowBox[{"tuples", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "3", "]"}], "]"}], "]"}], "<>", "\"\<.pdf\>\""}], 
         ",", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"informative", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"r", ",", " ", "0", ",", " ", 
             FractionBox["1", "2"]}], "}"}], ",", " ", 
           RowBox[{"AxesLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"r", ",", " ", 
              RowBox[{"\"\<Probability of \>\"", " ", "<>", " ", 
               RowBox[{"ToString", "[", 
                RowBox[{
                 RowBox[{"tuples", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "<>", 
               "\"\<, \>\"", " ", "<>", " ", 
               RowBox[{"ToString", "[", 
                RowBox[{
                 RowBox[{"tuples", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "]"}]}]}], "}"}]}]}], 
          "]"}]}], "]"}]}], "\[IndentingNewLine]", "]"}]}], "]"}]}], 
  "]"}]}], "Input"]
},
WindowSize->{1348, 670},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{595.1999999999999, 841.8}},
TrackCellChangeTimes->False,
FrontEndVersion->"10.0 for Linux x86 (64-bit) (June 27, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 123, 3, 32, "Input"],
Cell[684, 25, 883, 25, 77, "Input"],
Cell[1570, 52, 2294, 61, 165, "Input"],
Cell[3867, 115, 5067, 130, 429, "Input"],
Cell[8937, 247, 8776, 228, 411, "Input"],
Cell[17716, 477, 458, 12, 55, "Input"],
Cell[18177, 491, 134, 4, 32, "Input"],
Cell[18314, 497, 172, 6, 32, "Input"],
Cell[18489, 505, 264, 8, 32, "Input"],
Cell[18756, 515, 561, 15, 55, "Input"],
Cell[19320, 532, 147, 4, 32, "Input"],
Cell[19470, 538, 512, 14, 55, "Input"],
Cell[19985, 554, 295, 7, 32, "Input"],
Cell[20283, 563, 398, 10, 32, "Input"],
Cell[20684, 575, 4300, 109, 486, "Input"],
Cell[24987, 686, 115, 3, 32, "Input"],
Cell[25105, 691, 647, 20, 55, "Input"],
Cell[25755, 713, 704, 16, 77, "Input"],
Cell[26462, 731, 3684, 113, 142, "Input"],
Cell[30149, 846, 2613, 71, 187, "Input"],
Cell[32765, 919, 12917, 325, 926, "Input"],
Cell[45685, 1246, 173, 4, 32, "Input"],
Cell[45861, 1252, 194, 6, 32, "Input"],
Cell[46058, 1260, 167, 4, 32, "Input"],
Cell[46228, 1266, 115, 3, 32, "Input"],
Cell[46346, 1271, 545, 16, 32, "Input"],
Cell[46894, 1289, 2191, 57, 137, "Input"],
Cell[49088, 1348, 12416, 372, 385, "Input"],
Cell[61507, 1722, 6368, 170, 369, "Input"],
Cell[67878, 1894, 1803, 62, 105, "Input"],
Cell[69684, 1958, 776, 25, 63, "Input"],
Cell[70463, 1985, 727, 24, 63, "Input"],
Cell[71193, 2011, 6549, 202, 594, "Input"],
Cell[77745, 2215, 153, 4, 32, "Input"],
Cell[77901, 2221, 282, 8, 32, "Input"],
Cell[78186, 2231, 381, 9, 32, "Input"],
Cell[78570, 2242, 211, 7, 32, "Input"],
Cell[78784, 2251, 266, 8, 32, "Input"],
Cell[79053, 2261, 552, 15, 32, "Input"],
Cell[79608, 2278, 219, 7, 32, "Input"],
Cell[79830, 2287, 279, 6, 32, "Input"],
Cell[80112, 2295, 18645, 533, 871, "Input"],
Cell[98760, 2830, 262, 8, 32, "Input"],
Cell[99025, 2840, 4484, 137, 245, "Input"],
Cell[103512, 2979, 5579, 140, 429, "Input"],
Cell[109094, 3121, 1268, 34, 77, "Input"],
Cell[110365, 3157, 1193, 32, 77, "Input"],
Cell[111561, 3191, 1189, 32, 77, "Input"],
Cell[112753, 3225, 1264, 34, 77, "Input"],
Cell[114020, 3261, 1490, 39, 121, "Input"],
Cell[115513, 3302, 2362, 60, 210, "Input"],
Cell[117878, 3364, 85, 2, 32, "Input"],
Cell[117966, 3368, 3676, 94, 298, "Input"],
Cell[121645, 3464, 3665, 94, 298, "Input"]
}
]
*)

(* End of internal cache information *)
