% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpcross.R
\name{mpcross}
\alias{mpcross}
\title{Create object of class mpcross}
\usage{
mpcross(
  founders,
  finals,
  pedigree,
  hetData = infiniteSelfing,
  fixCodingErrors = FALSE
)
}
\arguments{
\item{founders}{The genetic data for the founding lines of the population, represented as an integer matrix.}

\item{finals}{The genetic data for the final lines of the population, represented as an integer matrix.}

\item{pedigree}{An object of class \code{pedigree}}

\item{hetData}{Information about how marker heterozygotes have been encoded. Can be an object of class \code{hetData}, or a function generating such an object from the previous three inputs.}

\item{fixCodingErrors}{Should we automatically fix data errors, by changing invalid values to missing?}
}
\value{
An object of class \code{mpcross}, constructed from the arguments.
}
\description{
Create object of class mpcross
}
\details{
This function constructs an object of class \code{mpcross} representing a multi-parent population. It takes in genetic data about the founding lines and final population line, a pedigree, and information about how marker heterozygotes have been encoded.

Parameter \code{founders} is the genetic data about the founding lines of the population. It must be an integer matrix, with rows representing genetic lines, and columns representing genetic markers. Parameter \code{finals} is a similar matrix, representing data for the final genetic lines in the population. 

Parameter pedigree stores information about how the final lines in the population were generated from the founding lines. 

Parameter hetDat must be an object of class \code{hetData} containing information about how marker heterozygotes have been encoded, OR a function which generates such an object. The function must take as arguments \code{founders, finals} and \code{pedigree}. See \code{\link{infiniteSelfing}} for an example of such a function.
}
