% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testDistortion.R
\name{testDistortion}
\alias{testDistortion}
\title{Test for distortion using IBD genotype probabilities}
\usage{
testDistortion(object)
}
\arguments{
\item{object}{An object of class \code{mpcrossMapped} which contains imputed IBD genotype data}
}
\value{
A data.frame containing p-values and test-statistic values for each position at which there is IBD genotype probability data.
}
\description{
Test for distortion using IBD genotype probabilities
}
\details{
In real experiments, genetic inheritance may not follow the expected model. This function tests for deviations from expected inheritance by using the genetic composition of the population at individual positions, as measured by the IBD genotype probabilities. 

At a particular point, the mean for each founder allele of the IBD genotype probabilities for each founder allele are summed across the population. The average is taken, and this is then compared with the proportion expected to be inherited from that founder, under standard models of genetic inheritance. 

The result is a matrix containing p-values, test-statistic values, and the L1 and L2 distances between the observed genetic proportions, and the expected genetic proportions.
}
