\name{mp}
\alias{mp}
\title{Define a multivariate polynomial.}
\usage{
  mp(string, varorder)
}
\arguments{
  \item{string}{a character string containing a polynomial,
  see examples}

  \item{varorder}{(optional) order of variables in string}
}
\value{
  An object of class mpoly.
}
\description{
  mp is a smart function which attempts to create a formal
  mpoly object from a character string containing the usual
  representation of a multivariate polynomial.
}
\examples{
( m <- mp('x + y + x y') )
is.mpoly( m )
unclass(m)

mp('x - y')
mp('x - 1')
mp('x +      y')
mp('x -      5')
mp('x - -5')
mp('10 x 6 x') # -> 60 x^2
mp('10 x 6 x + 10 x 6 x y y 2') # -> 60 x^2  +  120 x^2 y^2

mp('x^2 + x^2 y') # -> x^2  +  x^2 y

mp('x - x') # -> 0
mp('x - 4 x') # -> -3 x
mp('x y^2 - y^2 x') # -> 0

( ms <- mp(c('x + y', '2 x')) )
is.mpolyList(ms)

mp('10 x + 2 y 3 + x^2 5 y') # -> 10 x  +  6 y  +  5 x^2 y
mp('x + 2 y + x^2 y + x y z') # -> x  +  2 y  +  x^2 y  +  x y z
mp('x + 2 y + x^2 y + x y z', varorder = c('y', 'z', 'x')) # -> x  +  2 y  +  y  +  y z x
#mp('x + 2 y + x^2 y', varorder = c('q', 'p')) # -> error

mp('p111 + p121 2 p112^2')
unclass(mp('p111 + p121 2 p112^2'))

mp('0')
mp('2')
mp('-5')
mp('-4 x')
mp('y + -1 x')

gradient( mp('x + 2 y + x^2 y + x y z') )

# mp and the print methods are kinds of inverses of each other
( polys <- mp(c('x + y', 'x - y')) )
strings <- print(polys)
strings
mp(strings)

# possible specification syntax issues -
mp('x + 4x') # note the 4x as opposed to 4 x
mp('x - 4x') # same
mp('x -1') # -> x  -  11 -11

# future -
#mp('(x-2)^2')
}
\author{
  David Kahle \email{david.kahle@gmail.com}
}
\seealso{
  \code{\link{mpoly}}
}

