\name{as.function.mpolyList}
\alias{as.function.mpolyList}
\title{Change a vector of multivariate polynomials into a function.}
\usage{
\method{as.function}{mpolyList}(x, varorder = vars(x), vector = TRUE, ...)
}
\arguments{
  \item{x}{an object of class mpolyList #}

  \item{varorder}{the order in which the arguments of the
  function will be provided (default vars(mpoly)) #}

  \item{vector}{whether the function should take a vector
  argument (TRUE) or a series of arguments (FALSE)}

  \item{...}{any additional arguments}
}
\description{
Transforms an mpolyList object into a function which can be
evaluated.
}
\examples{
mpolyList <- mp(c('2 x + 1', 'x - z^2'))
f <- as.function(mpolyList)
f(c(1,2)) # -> (2*1 + 1, 1-2^2) = 3 -3

f <- as.function(mpolyList, varorder = c('x','y','z'))
f(c(1,0,2)) # -> 3 -3
f(c(1,4,2)) # -> 3 -3

f <- as.function(mpolyList, varorder = c('x','y','z'), vector = FALSE)
f(1, 0, 2) # -> 3 -3
f(1, 4, 2) # -> 3 -3


mpoly <- mp('x + y^2 + y z')
mpolyList <- gradient(mpoly)
f <- as.function(mpolyList, varorder = vars(mpoly))
f(c(0,2,3)) # -> 1 7 2
# nice for supplying gradient functions
}

