% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bernstein.R
\name{bernstein}
\alias{bernstein}
\title{Bernstein polynomials}
\usage{
bernstein(k, n, indeterminate = "x")
}
\arguments{
\item{k}{Bernstein polynomial k}

\item{n}{Bernstein polynomial degree}

\item{indeterminate}{indeterminate}
}
\value{
a mpoly object
}
\description{
Bernstein polynomials
}
\examples{

bernstein(0, 0)

bernstein(0, 1)
bernstein(1, 1)

bernstein(0, 1, "t")

bernstein(0:2, 2)
bernstein(0:3, 3)
bernstein(0:3, 3, "t")


bernstein(0:4, 4)
bernstein(0:10, 10)
bernstein(0:10, 10, "t")
bernstein(0:20, 20, "t")

\dontrun{  # visualize the bernstein polynomials

library(ggplot2); theme_set(theme_classic())
library(tidyr)

s <- seq(0, 1, length.out = 101)
N <- 10 # number of bernstein polynomials to plot
(bernPolys <- bernstein(0:N, N))

df <- data.frame(s, as.function(bernPolys)(s))
names(df) <- c("x", paste0("B_", 0:N))
head(df)

mdf <- gather(df, degree, value, -x)
head(mdf)

qplot(x, value, data = mdf, geom = "line", color = degree)

}

}
\author{
David Kahle
}

