% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{editmetabolitesmrbin}
\alias{editmetabolitesmrbin}
\title{A function for editing metabolite identities.}
\usage{
editmetabolitesmrbin(
  mrbinObject,
  borders = NULL,
  metabolitenames = NULL,
  add = FALSE,
  ids = NULL
)
}
\arguments{
\item{mrbinObject}{An mrbin object}

\item{borders}{A matrix of signal borders. 1D: two columns: left, right. 2D: four columns: left, right, top, bottom}

\item{metabolitenames}{A character vector of metabolite identities}

\item{add}{Should the new metabolite list be added to an existing list, or replace the current list?}

\item{ids}{A matrix of potential metabolite identities. This has to be a matrix with columns indicating left, right, top, bottom. Rownames are metabolite names. If this matrix is not provided, borders and metabolitenames have to be provided.}
}
\value{
An (invisible) mrbin object
}
\description{
This function edits the metabolite list within an mrbin object and returns it
}
\examples{
 results<-mrbin(silent=TRUE,
                   parameters=list(verbose=TRUE,dimension="1D",PQNScaling="No",
                   binwidth1D=0.04,signal_to_noise1D=1,PCA="No",binRegion=c(9.5,0.5,10,156),
                   saveFiles="No",referenceScaling="No",noiseRemoval="No",
                   fixNegatives="No",logTrafo="No",noiseThreshold=.05,tryParallel=TRUE,
                   NMRfolders=c(system.file("extdata/2/10/pdata/10",package="mrbin"),
                              system.file("extdata/3/10/pdata/10",package="mrbin"))
                   ))
 results<-editmetabolitesmrbin(results,borders=matrix(c(
     1.346,1.324,
     4.12,4.1,
     3.052,3.043,
     4.066,4.059
   ),ncol=2,byrow=TRUE),metabolitenames=c(
   "Lactate",
   "Lactate",
   "Creatinine",
   "Creatinine"
   ))
results$parameters$metaboliteIdentities
}
