% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/region_shp.R
\name{mr_shp}
\alias{mr_shp}
\title{Get a region shp file}
\usage{
mr_shp(key = NULL, name = NULL, maxFeatures = 50, overwrite = TRUE,
  read = TRUE, filter = NULL, ...)
}
\arguments{
\item{key}{(character) Region key, of the form \code{x:y}, where
\code{x} is a namespace (e.g., \code{MarineRegions}), and \code{y} is
a region (e.g., \code{eez_33176})}

\item{name}{(character) Region name, if you supply this, we search
against titles via \code{\link{mr_names}} function}

\item{maxFeatures}{(integer) Number of features}

\item{overwrite}{(logical) Overwrite file if already exists. Default: \code{FALSE}}

\item{read}{(logical) To read in as spatial object. If \code{FALSE} a path
given back. if \code{TRUE}, you need the \code{rgdal} package installed.
Default: \code{FALSE}}

\item{filter}{(character) String to filter features on}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A \code{SpatialPolygonsDataFrame} if \code{read=TRUE}, or a path to
a SHP file on disk if \code{read=FALSE}.
}
\description{
Get a region shp file
}
\details{
We use \pkg{rappdirs} to determine where to cache data depening on
your operating system. See \code{rappdirs::user_cache_dir("mregions")} for
location on your machine
}
\examples{
\dontrun{
## just get path
mr_shp(key = "MarineRegions:eez_33176", read = FALSE)
## read shp file into spatial object
res <- mr_shp(key = "MarineRegions:eez_33176", read = TRUE)

mr_shp(key = "SAIL:w_marinehabitatd")

if (requireNamespace("leaflet")) {
  library('leaflet')
  leaflet() \%>\%
    addProviderTiles(provider = "Stamen.TonerHybrid") \%>\%
    addPolygons(data = res)
}

# use `filter` param to get a subset of a region
mr_shp(name="World Marine Heritage Sites", maxFeatures=NULL,
  filter="iSimangaliso Wetland Park")
}
}

