% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_gaz_geom.R
\name{gaz_rest_geometries}
\alias{gaz_rest_geometries}
\title{Get the geometries associated with a gazetteer record}
\usage{
gaz_rest_geometries(mrgid, format = "sfc", multipart = TRUE, ...)
}
\arguments{
\item{mrgid}{(integer) A valid Marine Regions Gazetteer Identifier (\link{MRGID})}

\item{format}{(character) The preferred output format. One of:
\itemize{
\item "sfc": Simple Feature geometry object. See 'sf'
\item "wkt": Geometry representation as \href{https://en.wikipedia.org/wiki/Well-known_text}{Well-Known Text}
\item "rdf": Geometry as an object of class 'rdf". See 'rdflib'
}

Default is "sfc"}

\item{multipart}{(logical) Some Geo-Objects are compound of more than one part.
\itemize{
\item If FALSE, returns singlepart geometries (e.g. POLYGON, LINESTRING)
\item If TRUE (default), returns multipart geometries (e.g. MULTIPOLYGON, MULTILINESTRING)
}}

\item{...}{reserved for internal use}
}
\value{
A sfc object (default), a sf data frame, a WKT string
or an RDF object
}
\description{
Get the geometries associated with a gazetteer record
}
\examples{
\donttest{
gaz_rest_geometries(3293)
gaz_rest_geometries(3293, format = "wkt")
gaz_rest_geometries(3293, format = "rdf")
}
}
\seealso{
\link{gaz_rest}
}
