% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inven.R
\name{check_data_names}
\alias{check_data_names}
\title{Check input data set names against model parameters}
\usage{
check_data_names(
  data,
  x,
  check_covariates = TRUE,
  check_inputs = TRUE,
  tags = NULL,
  mode = c("warn", "error", "inform"),
  silent = FALSE
)
}
\arguments{
\item{data}{a data frame or other object with names to check.}

\item{x}{a model object.}

\item{check_covariates}{logical; if \code{TRUE}, check \code{data} for parameter names
carrying the \code{covariates} tag.}

\item{check_inputs}{logical; if \code{TRUE}, check \code{data} for parameter names
carrying the \code{input} tag.}

\item{tags}{a character vector of user-defined parameter tags to require
in \code{data}; this may be a comma- or space-separated string (e.g.
\code{"tag1,tag2"}).}

\item{mode}{the default is to \code{"warn"} the user when \code{data} is missing
some expected column names; alternatively, use \code{"error"} to issue an
error or \code{"inform"} to generate a message when \code{data} is missing some
expected column names.}

\item{silent}{silences message on successful check.}
}
\value{
A logical value is returned; \code{TRUE} if all expected parameters were found
and \code{FALSE} otherwise.
}
\description{
Use this function to check names of input data sets against parameters that
have been assigned different tags. Assignment is made in the model
specification file. This is useful to alert the user to misspelled or
otherwise misspecified parameter names in input data sets. See \code{\link[=param_tags]{param_tags()}}
for information on associating tags with parameters.
}
\details{
By default, \code{data} will be checked for parameters with the \code{covariates} or
\code{input} tags; these checks can be bypassed with the \code{check_covariates}
and \code{check_inputs} arguments. When a parameter name is missing from \code{data}
the user will be warned by default. Use \code{mode = "error"} to generate an
error instead of a warning and use \code{mode = "inform"} to simply be informed.
When the user has not tagged any parameters for checking, there will
either be a warning (default) or an error (when \code{mode = "error"}).

It is an error to request a parameter tag via the \code{tags} argument when that
tag is not found in the model.

It is an error to call \code{check_data_names} when no parameters have been tagged
in the model specification file (see \code{\link[=param_tags]{param_tags()}}).
}
\examples{

mod <- mcode("ex-cdn", "$PARAM @input \n CL = 1, KA = 2", compile = FALSE)

param(mod)

# Coding mistake!
data <- expand.evd(amt = 100, cl = 2, KA = 5)

check_data_names(data, mod)

try(check_data_names(data, mod, mode = "error"))

check_data_names(data, mod, mode = "inform")

}
\seealso{
\code{\link[=param_tags]{param_tags()}}
}
