% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_long.R
\name{reshape_long}
\alias{reshape_long}
\title{Reshape dataset to long format - stats::reshape version}
\usage{
reshape_long(wide_df, case_id_var, time_id_var, datsize = Inf, chunks = 1)
}
\arguments{
\item{wide_df}{dataframe in wide format}

\item{case_id_var}{String with name of ID variable indicating same patient.
E.g. \code{idvar="PUBCSNUM"} for SEER data.}

\item{time_id_var}{String with name of variable that indicates diagnosis per patient.
E.g. \code{timevar="SEQ_NUM"} for SEER data.}

\item{datsize}{Number of rows to be taken from df. This parameter is mainly for testing. Default is Inf so that df is fully processed.}

\item{chunks}{Numeric; default 1. Technical parameter how the data is split during reshaping.}
}
\value{
long df
}
\description{
Reshape dataset to long format - stats::reshape version
}
\examples{

data(us_second_cancer)

#prep step - reshape wide a sample of 10000 rows from us_second_cancer
usdata_wide_sample <- msSPChelpR::reshape_wide(us_second_cancer,
                         case_id_var = "fake_id", 
                         time_id_var = "SEQ_NUM", 
                         timevar_max = 2,
                         datsize = 10000)

#now we can reshape long again
msSPChelpR::reshape_long(usdata_wide_sample,
                         case_id_var = "fake_id", 
                         time_id_var = "SEQ_NUM")


}
