% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msaR.R
\name{msaR}
\alias{msaR}
\title{msaR}
\usage{
msaR(msa, menu = TRUE, width = NULL, height = NULL, rowheight = 15,
  alignmentHeight = 225, overviewbox = TRUE, seqlogo = TRUE,
  conservation = FALSE, markers = TRUE, metacell = FALSE,
  leftheader = TRUE, labels = TRUE, labelname = TRUE, labelid = TRUE,
  labelNameLength = 100, overviewboxWidth = "auto",
  overviewboxHeight = "fixed")
}
\arguments{
\item{msa}{File or BioString  Object representing a multiple Sequence Alignment.}

\item{menu}{Optional. Default \code{TRUE}. Determines whether to include the interactive menu.}

\item{width}{Optional. Default \code{NULL}. The width of the html widget element.}

\item{height}{Optional. Default \code{NULL}. The height of the html widget element.}

\item{rowheight}{Optional. Default \code{20}. Height of a row in the MSA.}

\item{alignmentHeight}{Optional. Default \code{225}. Height of the MSA.}

\item{overviewbox}{optional. Default \code{TRUE}. Include the overview box?}

\item{seqlogo}{optional. Default \code{TRUE}. Include the seqlogo?}

\item{conservation}{optional. Default \code{TRUE}. Include the conservation widget?}

\item{markers}{optional. Default \code{TRUE}. Include the alignment markers? These are the numbers along the top that}

\item{metacell}{optional. Default \code{FALSE}. Include the per-sequence metadata.}

\item{leftheader}{optional. Default \code{TRUE}. Include the header information.}

\item{labels}{optional. Default \code{TRUE}. Include all of the sequence information msa Labels.}

\item{labelname}{optional. Default \code{TRUE}. Include sequence name?}

\item{labelid}{optional. Default \code{TRUE}. Include the labelid?}

\item{labelNameLength}{optional. Default \code{100}. Width of the Label Names.}

\item{overviewboxWidth}{optional. Default. \code{"auto"}. Can also be "fixed"}

\item{overviewboxHeight}{optional. Default. \code{"fixed"}. Can also be an integer value.}
}
\description{
Dynamic Multiple Sequence Alignments in R and Shiny
}
\examples{
seqfile <- system.file("sequences","AHBA.aln",package="msaR")
msaR(seqfile)
}

