% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msaefhns.R
\name{msaefhns}
\alias{msaefhns}
\title{EBLUPs under Multivariate Fay Herriot Model for non-sampled area}
\usage{
msaefhns(
  formula,
  vardir,
  cluster,
  nonsample,
  samevar = FALSE,
  MAXITER = 100,
  PRECISION = 1e-04,
  data
)
}
\arguments{
\item{formula}{List of formula that describe the fitted model}

\item{vardir}{Sampling variances of direct estimations included in data frame as the vector with the name of sampling variances in order : \code{var1, cov12,.,cov1r,var2,cov23,.,cov2r,.,cov(r-1)(r),var(r)}}

\item{cluster}{cluster information}

\item{nonsample}{A column with logical values, \code{TRUE} if the area is non-sampled}

\item{samevar}{Whether the variances of the data are same or not. Logical input with default \code{FALSE}}

\item{MAXITER}{Maximum number of iteration in Fisher-scoring algorithm with default \code{100}}

\item{PRECISION}{Limit of Fisher-scoring convergence tolerance with default \code{1e-4}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{MSAE_Eblup_sampled}{A dataframe with the values of the EBLUPs estimators for sampled areas}
   \item{MSAE_Eblup_all}{A dataframe with the values of the EBLUPs estimators for all areas}
   \item{MSE_Eblup_sampled}{A dataframe with the values of estimated mean square errors of EBLUPs estimators for sampled areas}
   \item{MSE_Eblup_all}{A dataframe with the values of estimated mean square errors of EBLUPs estimators for all areas}
   \item{randomEffect_sampled}{a dataframe with the values of the random effect estimators for sampled areas}
   \item{randomEffect_all}{a dataframe with the values of the random effect estimators for all areas}
   \item{Rmatrix_sampled}{a block diagonal matrix composed of sampling errors for sampled areas}
   \item{fit}{A list containing the following objects:}
     \itemize{
       \item method : The fitting method (this function is using "REML")
       \item convergence : The convergence result of Fisher-scoring algorithm (Logical Value)
       \item iterations : The number of Fisher-Scoring algorithm iterations
       \item estcoef : A dataframe with the estimated model coefficient, standard error,t statistics, p-values of the significance of each coefficient
       \item refvar : A dataframe with estimated random effect variances
       \item informationFisher : A matrix of information fisher from Fisher-scoring algorithm
     }
}
\description{
This function produces EBLUPs and MSE of Multivariate SAE with Difference Benchmarking for non-sampled area
}
\examples{
##load dataset
data(datamsaeDBns)
#Note : Make sure yout dataset does not contain NA Values
#       you can set 0 in Direct estinations and vardir for non-sampled areas.

#Compute Fitted model for Y1, Y2, and Y3
#Y1 ~ X1 + X2
#Y2 ~ X1 + X2
#Y3 ~ X1 + X2

##Using parameter 'data'
formula = list(f1 = Y1~X1+X2,
               f2 = Y2~X1+X2,
               f3 = Y3~X1+X2)
vardir = c("v1","v12","v13","v2","v23","v3")
cluster = c("clY1","clY2","clY3")
nonsample = "nonsample"
msaeFHns <- msaefhns(formula,vardir, cluster, nonsample, data=datamsaeDBns)

}
