% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msaenet-misc.R
\name{msaenet.nzv}
\alias{msaenet.nzv}
\title{Get Indices of Non-Zero Variables}
\usage{
msaenet.nzv(object)
}
\arguments{
\item{object}{An object of class \code{msaenet} produced
by \code{\link{aenet}} or \code{\link{msaenet}}.}
}
\value{
Indices vector of non-zero variables in the model.
}
\description{
Get the indices of non-zero variables from AENet/MSAENet model objects.
}
\examples{
dat = msaenet.sim.gaussian(n = 150, p = 500, rho = 0.6,
                           coef = rep(1, 5), snr = 2, p.train = 0.7,
                           seed = 1001)

msaenet.fit = msaenet(dat$x.tr, dat$y.tr,
                      alphas = seq(0.2, 0.8, 0.2),
                      nsteps = 3L, seed = 1003)

msaenet.nzv(msaenet.fit)

# coefficients of non-zero variables
coef(msaenet.fit)[msaenet.nzv(msaenet.fit)]
}
\author{
Nan Xiao <\url{http://nanx.me}>
}

