#Copyright 2004, W. Wolski, all rights reserved.
as.data.frame.mlist<-function(x,row.names=NULL,optional = FALSE)
  {
    ##t Data Frames
    ##- Turns the mlist object into a data.frame
    ##d These functions create a data frame, tightly coupled
    ##d collections of variables which share many of the properties of
    ##d matrices and of lists, used as the fundamental data structure by
    ##d most of R's modeling software.
    ##+ x : object of class massvectorlist
    ##+ ... : further arguments
    ##sa as.matrix.mlist, as.matrix
    ##e data(mvl)
    ##e tmp <- as.data.frame(mvl)
    ##e names(mvl)
    ##e plot(tmp$lengthmv,tmp$mass.Min.)
    ##e data(mvl)
    ##e mvl<-mvl[1:100]
    ##e data(cal)
    ##e test<-getintcalib(mvl,cal,error=500)
    ##e tmp<-as.data.frame(test)
    ##e names(tmp)
    res <- NULL
    tmp <- as.matrix(x)
    ntmp <- names(x)
    res <- data.frame(info=as.character(ntmp),tmp)
    res
  }


summary.mlist<-function(object,...)
  {
    ##t mist Summaries
    ##- Generates a summary for the data.frame generated by as.data.frame.mlist
    ##+ object : mlist
    ##+ ... : further arguments
    ##sa summary.massvector,as.data.frame.mlist
    ##e data(mvl)
    ##e summary(mvl)
    ##e data(mvl)
    ##e mvl<-mvl[1:100] 
    ##e data(cal)
    ##e test <- getintcalib(mvl,cal,error=500)
    ##e summary(test)

    res<-list(info = info(object))
    res<-c(res,list(summary=summary(as.matrix(object))))
    return(res)
  }


as.matrix.mlist<-function(x)
{
  ##t Matrices
  ##- Turns the caliblist into a matrix
  ##+ x : caliblist
  ##v matrix : matrix
  ##sa as.data.frame.mlist
  ##e data(mvl)
  ##e mvl<-mvl[1:100]
  ##e data(cal)
  ##e test<-getintcalib(mvl,cal,error=500)
  ##e tmp<-as.matrix(test)
  ##e colnames(tmp)
  ##e dim(tmp)
  ##e data(mvl)
  ##e tmp<-as.matrix(mvl)
  ##e print(colnames(mvl))
  ##e plot(tmp[,"lengthmv"],tmp[,"mass.Min."])
  dat<-t(sapply(x,as.vector))
  dat
}


image.mlist<-function(x,what="",col=terrain.colors(100),...)
  {
    ##t Display a Color Image
    ##- Creates a grid of colored or gray-scale rectangles with colors
    ##- corresponding to the values in 'z'.  This can be used to display
    ##- three-dimensional or spatial data aka "images". This is a generic
    ##- function.
    ##+ x : object of class mlist. (e.g: caliblist or massvectorlist)
    ##+ what : what value to display on the image.
    ##+ col : a list of colors such as that generated by 'rainbow', 'heat.colors', 'topo.colors', 'terrain.colors' or similar functions.
    ##e data(mvl)
    ##e image(mvl,what="lengthmv")
    cal<-x
    rm(x) # do not like to use x.
    if(length(cal)==0){
      warning("List has length 0")
      return()
    }
    res <- as.matrix(cal)
    if(! what %in% colnames(res))
      stop("Only following fields can be shown for ", class(cal)[1]," : \n", join(colnames(res),sep=" "),"\n pass one to the what paramter.")
    nam <- mget(cal,"tcoor")
    if(!is.null(names(nam$coorX)) & !is.null(names(nam$coorY)))
      {
        X <- nam$coorX[unique(names(nam$coorX))]
        Y <- nam$coorY[unique(names(nam$coorY))]
        XX <- 1:max(X)
        names(XX)<-rep("",max(X))
        names(XX)[X]<-names(X)
        X<-XX
        YY <- 1:max(Y)
        names(YY)<-rep("",max(Y))
        names(YY)[Y]<-names(Y)
        Y<-YY
      }
    else
      {
        X <- unique(nam$coorX)
        Y <- unique(nam$coorY)
      }
    hello <- matrix(NA,max(X),max(Y))
   


    for(z in 1:length(cal))
      {
        hello[ nam$coorX[z] , nam$coorY[z] ] <- res[z,what]
      }

    if(!is.null(names(X)) & !is.null(names(Y)))
       {
         rownames(hello) <- names(X)
         colnames(hello) <- names(Y)
       }

    par(bg="gray")
    tmar<-par()$mar
                                        #define layout
    nf <- layout(matrix(c(1,2),1,2),widths=c(5,1), TRUE)
    par(mar=c(3,3,2,0.5))
                                        #2.03.2004
    image(t(hello) , main=what,xaxs="i",yaxs="i",axes=FALSE,col=col,...)
    #image(hello , main=what,xaxs="i",yaxs="i",axes=FALSE,col=col,...)
    if((length(Y)-1)>0)
      {
        axis( 1 , at=seq(0,1,1/(length(Y)-1)) , labels=names(sort(Y)))
      }
    else
      {
         axis(1,at=0.5,labels=names(Y))
      }
    if((length(X)-1)>0)
      {
        axis( 2 , at=seq(0,1,1/(length(X)-1)) , labels=names(sort(X)))
      }
    else
      {
        axis(2,at=6,labels=names(X))
      }
    tres<-na.omit(c(hello))
    if(min(tres)!=max(tres))
      {
        scale<-seq(min(tres),max(tres),(max(tres)-min(tres))/9)
      }
    else
      {
        scale<-rep(min(tres),10)
      }
    scale<-matrix(scale,nrow=1)
    par(mar=c(3,0,2,0.5))
                                        #check for scalig factor
    #pp<-mget(cal[[1]],"ppm")
    lable<-""
    #if(!is.null(pp))
    #  {
    #    lable<-ifelse(pp,"* -1e4","* -1e6")
    #  }
    image(1,1:10,scale,axes=FALSE,xlab="",ylab="",col=col,main=lable )
    scalet<-format(scale,digits=1)
    for(x in 1:length(scalet))
      {
        text(0.5,x,scalet[x])
      }
    par(mar=tmar)
    layout(matrix(1))
    invisible(t(hello))
  }


mget.mlist<-function(object,attrn,...)
  {
    ##t Field Access
    ##- Acces fields in object of class myobj
    ##+ object : object of class  mlist
    ##+ attrn : name of field (Attribute)
    ##e data(mvl)
    ##e mget(mvl)
    ##e mget(mvl,"info")
    ##e mget(mvl,"tcoor")
    if(missing(attrn))
      return(attr(object,"allow"))
    if(attrn %in% "tcoor")
      {
        res <- NULL
        nres<-NULL
        for(x in object)
          {
            res <- rbind( res , mget(x,"tcoor") )
            nres <- rbind( nres,names(mget(x,"tcoor")) )
          }
        coorX <- res[,1]
        names(coorX) <- nres[,1]
        coorY<-res[,2]
        names(coorY)<-nres[,2]
        return(list(coorX=coorX,coorY=coorY))
      }
    else
      NextMethod("mget")
  }

experiment.mlist<-function(object,experiment,...)
  {
    ##t Info Acces
    ##- Access to the experiment field of the mlist. Can be used for setting or getting the experiment field.
    ##a info.mlist
    ##+ object : object of class mlist
    ##+ experiment : New experiment name. If not missing function returns massvector with new info field content.
    ##e data(mvl)
    ##e experiment(mvl)
    ##e mvl<-experiment(mvl,"newname")
    if(missing(experiment))
      return(mget(object,"experiment"))
    else
      {
        setParms(object)<-list(experiment=experiment)
      }
    object
  }

info.mlist<-experiment.mlist

subset.mlist <- function(x,subset,...)
  {
    ##t Subset mlist
    ##- Return subsets of list elements which meet conditions.
    ##+ x : object of class mlist
    ##+ subset : logical expression.
    ##e data(mvl)
    ##e mvl<-subset(mvl,lengthmv>30)
    u <- as.data.frame(x)
    if (missing(subset))
      {
        r <- TRUE
        cat("For subsetting use comparison on : \n", join(names(u),sep=" ")  ,"\n")
        return()
      }
    else {
        e <- substitute(subset)
        r <- eval(e, u, parent.frame())
        r <- r & !is.na(r)
    }
    vars <- TRUE
    u <- u[r, vars, drop = FALSE]
    x[as.character(u$info)]
}
