% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weblmInit.R
\name{weblmInit}
\alias{weblmInit}
\title{Initializes the \pkg{mscsweblm4r} package.}
\usage{
weblmInit()
}
\description{
This function initializes the Microsoft Cognitive Services Web
Language Model REST API key and URL by reading them either from a
configuration file or environment variables.

This function \strong{MUST} be called right after package load and before calling
any \pkg{mscsweblm4r} core functions, or these functions will fail.

The \code{\link{weblmInit}} configuration function will first check to see
if the variable \code{MSCS_WEBLANGUAGEMODEL_CONFIG_FILE} exists in the system
environment. If it does, the package will use that as the path to the
configuration file.

If \code{MSCS_WEBLANGUAGEMODEL_CONFIG_FILE} doesn't exist, it will look for
the file \code{.mscskeys.json} in the current user's home directory (that's
\code{~/.mscskeys.json} on Linux, and something like \code{C:/Users/Phil/Documents/.mscskeys.json}
on Windows). If the file is found, the package will load the API key and URL
from it.

If using a file, please make sure it has the following structure:

\preformatted{
{
  "weblanguagemodelurl": "https://api.projectoxford.ai/text/weblm/v1.0/",
  "weblanguagemodelkey": "...MSCS Web Language Model API key goes here..."
}
}

If no configuration file is found, \code{\link{weblmInit}} will attempt to
pick up its configuration information from two Sys env variables instead:

\code{MSCS_WEBLANGUAGEMODEL_URL} - the URL for the Web LM REST API.

\code{MSCS_WEBLANGUAGEMODEL_KEY} -  your personal Web LM REST API key.

\code{\link{weblmInit}} needs to be called \emph{only once}, after package
load.
}
\examples{
\dontrun{
 weblmInit()
}
}
\author{
Phil Ferriere \email{pferriere@hotmail.com}
}

