% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msdDates.R
\name{msdDates}
\alias{msdDates}
\title{Finding indices for Dates Relevant to the MSD Calculations}
\usage{
msdDates(x, peakwindow1, minwindow1, minwindow2, peakwindow2)
}
\arguments{
\item{x}{Date vector}

\item{peakwindow1}{desired date in MMDD format to begin search for early peak}

\item{minwindow1}{desired date in MMDD format to begin search for minimum}

\item{minwindow2}{desired date in MMDD format to end search for minimum}

\item{peakwindow2}{desired date in MMDD format to end search for late peak}
}
\value{
Vector containing the indices corresponding to each year's beginning date, end date, and the critical MSD dates
}
\description{
This function pulls the indices associated with the dates that correspond
with the Mid Summer Drought, as well as the indices that indicate first and last day of each year.
This function is used in conjunction with the MSD function.
}
\examples{
x <- seq(from = as.Date("1981-01-01"), to = as.Date("1985-12-31"), by = "day")
output <- msdDates(x, peakwindow1 = "05-01", minwindow1 = "06-01",
                    minwindow2 = "08-31", peakwindow2 = "10-31")

}
