% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigate.R
\name{coef.msgl}
\alias{coef.msgl}
\title{Nonzero coefficients}
\usage{
\method{coef}{msgl}(object, index = 1:nmod(object), ...)
}
\arguments{
\item{object}{a msgl object}

\item{index}{indices of the models}

\item{...}{ignored}
}
\value{
a list of length \code{length(index)} with nonzero coefficients of the models
}
\description{
This function returns the nonzero coefficients (that is the nonzero entries of the \eqn{beta} matrices)
}
\examples{
data(SimData)


lambda <- msgl::lambda(x, classes, alpha = .5, d = 50, lambda.min = 0.05)
fit <- msgl::fit(x, classes, alpha = .5, lambda = lambda)

# the nonzero coefficients of the models 1, 10 and 20
coef(fit, index = c(1,10,20))

}
\author{
Martin Vincent
}
