% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\docType{class}
\name{Report}
\alias{Report}
\title{Extract a MicroStrategy report into a R Data.Frame}
\format{An object of class \code{R6ClassGenerator} of length 25.}
\usage{
Report
}
\description{
Access, filter, publish, and extract data from in-memory reports.
Create a Report object to load basic information on a report dataset. Specify subset of report
to be fetched through Report.apply_filters() and Report.clear_filters() . Fetch dataset through
Report.to_dataframe() method.
}
\section{Fields}{

\describe{
\item{\code{connection}}{MicroStrategy connection object}

\item{\code{report_id}}{Identifier of a report.}
}}

\examples{
\donttest{
# Create a connection object.
connection = connect_mstr(base_url, username, password, project_name)

# Create a report object.
my_report <- Report$new(connection, report_id)

# See attributes and metrics in the report.
my_report$attributes
my_report$metrics
my_report$attr_elements

# Specify attributes and metrics (columns) to be fetched.
my_report$apply_filters(attributes = my_report$attributes[1:2],
                           metrics = my_report$metrics[1:2])

# See the selection of attributes, metrics and attribute elements.
my_report$selected_attributes
my_report$selected_metrics
my_report$selected_attr_elements

# Clear filtering to load a full dataset.
my_report$clear_filters()

# Fetch data from the Intelligence Server.
my_report$to_dataframe()

# See the dataframe.
my_report$dataframe
}
}
\keyword{datasets}
