% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.mtrank.R
\name{forest.mtrank}
\alias{forest.mtrank}
\title{Forest plot of ability estimates produced with \code{\link{mtrank}}}
\usage{
\method{forest}{mtrank}(
  x,
  sorting = "ability",
  backtransf = FALSE,
  xlab = "",
  leftcols = "studlab",
  leftlabs = "Treatment",
  rightcols = c("effect", "ci"),
  rightlabs = c(paste0(if (!backtransf) "log-", "Abilities"), NA),
  label.left = "Favors average treatment",
  label.right = "Favors treatment",
  header.line = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{mtrank}}.}

\item{sorting}{An argument specifying the criterion to sort the ability
estimates in the forest plot (see Details).}

\item{backtransf}{A logical argument specifying whether to show log-ability
estimates (\code{FALSE}, default) or ability estimates on the natural
scale (\code{TRUE}).}

\item{xlab}{A label for the x-axis.}

\item{leftcols}{A character vector specifying columns
to be printed on the left side of the forest plot
(see \code{\link[meta]{forest.meta}}).}

\item{leftlabs}{A character vector specifying labels for
columns on left side of the forest plot.}

\item{rightcols}{A character vector specifying columns
to be printed on the right side of the forest plot
(see \code{\link[meta]{forest.meta}}).}

\item{rightlabs}{A character vector specifying labels for
columns on right side of the forest plot.}

\item{label.left}{Graph label on left side of null effect.}

\item{label.right}{Graph label on right side of null effect.}

\item{header.line}{A logical value indicating whether to print a
header line or a character string ("both", "below", "").}

\item{\dots}{Additional arguments (passed on to
\code{\link[meta]{forest.meta}}).}
}
\value{
A forest plot is plotted in the active graphics device.
}
\description{
This function produces a forest plot that visualizes the ability estimates
calculated with \code{\link{mtrank}}.
}
\details{
The function produces a forest plot and visualizes the ability estimates
obtained from \code{\link{mtrank}}. The order of the estimates in the
forest plot (argument \code{sorting}) can be one of the following:
\itemize{
\item "ability": sort by descending ability estimates (default),
\item "se": sort by descending precision, i.e., increasing standard errors,
\item "none": use order from data set.
}
}
\examples{
data(antidepressants)
#
ranks <- tcc(treat = drug_name, studlab = studyid,
  event = responders, n = ntotal, data = antidepressants,
  mcid = 1.25, sm = "OR", small.values = "undesirable")
#
fit <- mtrank(ranks)

forest(fit, treat = "escitalopram")

}
\references{
Evrenoglou T, Nikolakopoulou A, Schwarzer G, Rücker G, Chaimani A (2024):
Producing treatment hierarchies in network meta-analysis using probabilistic
models and treatment-choice criteria.
\url{https://arxiv.org/abs/2406.10612}
}
\keyword{hplot}
