% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.mudata}
\alias{autoplot.mudata}
\alias{plot.mudata}
\title{Autoplot a mudata object}
\usage{
\method{autoplot}{mudata}(object, facets = "param", col = "location",
  pch = "dataset", ...)

\method{plot}{mudata}(x, facets = "param", col = "location",
  pch = "dataset", ...)
}
\arguments{
\item{facets}{Column to be used as facet column}

\item{col}{Column to be used as colour aesthetic}

\item{pch}{Column to be used as shape aesthetic}

\item{...}{Passed on to \link{long_plot} or \link{long_ggplot}}

\item{x, object}{A \link{mudata} object}
}
\description{
Produces a quick graphical summary of a mudata object. The \code{autoplot()}
function is based on ggplot2's \link[ggplot2:qplot]{qplot}, and is the preferred
(and most flexible) plotting method. The \code{plot()} function uses
base R graphics and produces quick summary plot, but is unlikely to be
useful in any other context. Note that all column names must be quoted
(i.e., \code{aesthetic = "col_name"} not \code{aesthetic = col_name}).
}
\examples{
# plot using base plot
plot(kentvillegreenwood)

# a more informative plot using ggplot
autoplot(kentvillegreenwood)

}
\seealso{
\link{long_ggplot}
}
