% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mudata_subset.R
\name{select_datasets}
\alias{select_datasets}
\alias{select_datasets.default}
\alias{select_locations}
\alias{select_locations.default}
\alias{select_params}
\alias{select_params.default}
\title{Subset a mudata object by identifier}
\usage{
select_datasets(.data, ...)

\method{select_datasets}{default}(.data, ..., .factor = FALSE)

select_locations(.data, ...)

\method{select_locations}{default}(.data, ..., .factor = FALSE)

select_params(.data, ...)

\method{select_params}{default}(.data, ..., .factor = FALSE)
}
\arguments{
\item{.data}{A mudata object}

\item{...}{Quoted names, bare names, or helpers like \link[dplyr:starts_with]{starts_with},
\link[dplyr:contains]{contains}, \link[dplyr:ends_with]{ends_with}, \link[dplyr:one_of]{one_of},
or \link[dplyr:matches]{matches}.}

\item{.factor}{If TRUE, the new object will keep the order specified by converting
columns to factors. This may be useful for specifying order when using
\link{autoplot.mudata}.}
}
\value{
A subsetted mudata object.
}
\description{
These functions use dplyr-like selection syntax to quickly subset a mudata
object by param, location, or dataset. Params, locations, an datasets can also
be renamed using keyword arguments, identical to dplyr selection syntax.
}
\examples{
# renaming can be handy when locations are verbosely named
ns_climate \%>\% 
  select_locations(sable_island = starts_with("SABLE"),
                   nappan = starts_with("NAPPAN"), 
                   baddeck = starts_with("BADDECK")) \%>\% 
  select_params(ends_with("temp"))
  
# can also use quoted values
long_lake \%>\%
  select_params("Pb", "As", "Cr")

# can also use negative values to remove params/datasets/locations
long_lake \%>\%
  select_params(-Pb)
  
# to get around non-standard evaluation, use one_of()
my_params <- c("Pb", "As", "Cr")
long_lake \%>\%
  select_params(one_of(my_params))

}
\seealso{
\link[dplyr:select]{select}, \link{rename_locations}, \link{distinct_locations},
\link{filter_locations}
}
