% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{reshape_results}
\alias{reshape_results}
\title{Reshape Results}
\usage{
reshape_results(
  model = NULL,
  model_results = NULL,
  model_ontology_col_name = "ontology_id",
  ontology_id_colname = "ontology_id",
  p_value_type_colname = "eFDR",
  p_value_max_threshold = TRUE
)
}
\arguments{
\item{model}{a mulea model, created by the
\code{ora} or the \code{gsea} functions.}

\item{model_results}{Result \code{data.frame}
returned by the \code{run_test} function.}

\item{model_ontology_col_name}{Character, specifies the column name in the
model that contains ontology IDs. It defines which column in the model
should be used for matching ontology IDs. Possible values are 'ontology_id'
and 'ontology_name'. The default value is 'ontology_id'.}

\item{ontology_id_colname}{Character, specifies the column name for ontology
IDs in the model results. It indicates which column in the model results
contains ontology IDs for merging. Possible values are 'ontology_id' and
'ontology_name'. The default value is 'ontology_id'.}

\item{p_value_type_colname}{Character, specifies the column name
for the type or raw or adjusted \emph{p}-value in the result
\code{data.frame} returned by the \code{run_test} function.
The default value is 'eFDR'.}

\item{p_value_max_threshold}{Logical, indicating whether to apply a
\emph{p}-value threshold when filtering the resulting data. If TRUE,
the function filters the data based on a \emph{p}-value threshold.}
}
\value{
Return detailed and relaxed \code{data.table} where model and results are
merged for plotting purposes.
}
\description{
This function takes a model and model_results data, reshapes
them into a suitable format for plotting, and returns the resulting data
frame, which can be used for further analysis or visualization.
}
\examples{
library(mulea)

# loading and filtering the example ontology from a GMT file
tf_gmt <- read_gmt(file = system.file(package="mulea", "extdata", 
    "Transcription_factor_RegulonDB_Escherichia_coli_GeneSymbol.gmt"))
tf_gmt_filtered <- filter_ontology(gmt = tf_gmt, min_nr_of_elements = 3, 
    max_nr_of_elements = 400)

# loading the example data
sign_genes <- readLines(system.file(
    package = "mulea", "extdata", "target_set.txt"))
background_genes <- readLines(
    system.file(package="mulea", "extdata", "background_set.txt"))

# creating the ORA model
ora_model <- ora(gmt = tf_gmt_filtered,
    # the test set variable
    element_names = sign_genes, 
    # the background set variable
    background_element_names = background_genes, 
    # the p-value adjustment method
    p_value_adjustment_method = "eFDR", 
    # the number of permutations
    number_of_permutations = 10000,
    # the number of processor threads to use
    nthreads = 2)
# running the ORA
ora_results <- run_test(ora_model)

# reshaping results for visualisation
ora_reshaped_results <- reshape_results(model = ora_model,
    model_results = ora_results,
    # choosing which column to use for the indication of significance
    p_value_type_colname = "eFDR")
}
\seealso{
\code{\link{plot_graph}}, \code{\link{plot_barplot}},
\code{\link{plot_heatmap}}
}
