% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{View_diffNetworks}
\alias{View_diffNetworks}
\title{Interactive visualisation of differential networks}
\usage{
View_diffNetworks(deggs_object, legend.arrow.width = 0.35, stepY_legend = 55)
}
\arguments{
\item{deggs_object}{an object of class \code{deggs} generated by
\code{get_diffNetworks}}

\item{legend.arrow.width}{width of the arrow used in the network legend.
Default is 0.35. As the number of assayData matrices increases this parameter
must be accordingly increased to avoid graphical errors in the legend.}

\item{stepY_legend}{vertical space between legend arrows. It is used together
with \code{legend.arrow.width} to adjust the legend space in case of graphical
errors. Default is 55.}
}
\value{
a shiny interface showing networks with selectable nodes and links
}
\description{
Explore differential networks and interactively select regression
and box plots
}
\examples{
data("synthetic_metadata")
data("synthetic_rnaseqData")
data("synthetic_proteomicData")
data("synthetic_OlinkData")
assayData_list <- list("RNAseq" = synthetic_rnaseqData,
                       "Proteomics" = synthetic_proteomicData,
                       "Olink" = synthetic_OlinkData)
deggs_object <- get_diffNetworks(assayData = assayData_list,
                                 metadata = synthetic_metadata,
                                 category_variable = "response",
                                 regression_method = "lm",
                                 verbose = FALSE,
                                 show_progressBar = FALSE,
                                 cores = 1)
# the below function runs a shiny app, so can't be run during R CMD check                                  
if(interactive()){
View_diffNetworks(deggs_object)  
}
}
