% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiblock_plots.R
\name{multiblock_plots}
\alias{multiblock_plots}
\alias{scoreplot.multiblock}
\alias{loadingplot.multiblock}
\alias{loadingweightplot}
\alias{biplot.multiblock}
\title{Plot Functions for Multiblock Objects}
\usage{
\method{scoreplot}{multiblock}(
  object,
  comps = 1:2,
  block = 0,
  labels,
  identify = FALSE,
  type = "p",
  xlab,
  ylab,
  main,
  ...
)

\method{loadingplot}{multiblock}(
  object,
  comps = 1:2,
  block = 0,
  scatter = TRUE,
  labels,
  identify = FALSE,
  type,
  lty,
  lwd = NULL,
  pch,
  cex = NULL,
  col,
  legendpos,
  xlab,
  ylab,
  main,
  pretty.xlabels = TRUE,
  xlim,
  ...
)

loadingweightplot(object, main = "Loading weights", ...)

\method{biplot}{multiblock}(
  x,
  block = 0,
  comps = 1:2,
  which = c("x", "y", "scores", "loadings"),
  var.axes = FALSE,
  xlabs,
  ylabs,
  main,
  ...
)
}
\arguments{
\item{object}{\code{multiblock} object.}

\item{comps}{\code{integer} vector giving components, within block, to plot.}

\item{block}{\code{integer/character} for block selection.}

\item{labels}{\code{character} indicating if "names" or "numbers" should be plot symbols (optional).}

\item{identify}{\code{logical} for activating \code{identify} to interactively identify points.}

\item{type}{\code{character} for selecting type of plot to make. Defaults to "p" (points) for scatter plots and "l" (lines) for line plots.}

\item{xlab}{\code{character} text for x labels.}

\item{ylab}{\code{character} text for y labels.}

\item{main}{\code{character} text for main header.}

\item{...}{Not implemented.}

\item{scatter}{\code{logical} indicating if a scatterplot of loadings should be made (default = TRUE).}

\item{lty}{Vector of line type specifications (see \code{\link{par}} for details).}

\item{lwd}{\code{numeric} vector of line width specifications.}

\item{pch}{Vector of point specifications (see \code{\link{points}} for details).}

\item{cex}{\code{numeric} vector of plot size expansions (see \code{\link{par}} for details).}

\item{col}{\code{integer} vector of symbol/line colours (see \code{\link{par}} for details).}

\item{legendpos}{\code{character} indicating legend position (if \code{scatter} is FALSE), e.g. \code{legendpos = "topright"}.}

\item{pretty.xlabels}{\code{logical} indicating if xlabels should be more nicely plotted (default = TRUE).}

\item{xlim}{\code{numeric} vector of length two, with the x limits of the plot (optional).}

\item{x}{\code{multiblock} object.}

\item{which}{\code{character} for selecting type of biplot ("x" = default, "y", "scores", "loadings").}

\item{var.axes}{\code{logical} indicating if second axes of a biplot should have arrows.}

\item{xlabs}{\code{character} vector for labelling first set of biplot points (optional).}

\item{ylabs}{\code{character} vector for labelling second set of biplot points (optional).}
}
\value{
These plotting routines only generate plots and return no values.
}
\description{
Plotting procedures for \code{multiblock} objects.
}
\details{
Plot functions for \code{scores}, \code{loadings} and \code{loading.weights} based
on the functions found in the \code{pls} package.
}
\examples{
data(wine)
sc <- sca(wine[c('Smell at rest', 'View', 'Smell after shaking')], ncomp = 4)
plot(loadings(sc, block = 1), labels = "names", scatter = TRUE)

}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results are found in \code{\link{multiblock_results}}.
}
