\name{plot_binary_RF}
\alias{plot_binary_RF}
\title{
  Plot binary rule-based heatmaps
}
\description{
  \code{plot_binary_RF} Plot binary heatmaps for datasets based on rule-based random forest classifier
}
\usage{
  plot_binary_RF(Data,
                  classifier,
                  ref              = NULL,
                  prediction       = NULL,
                  platform         = NULL,
                  classes          = NULL,
                  platforms_ord    = NULL,
                  top_anno         = c("ref", "prediction", "platform")[1],
                  title            = "",
                  binary_col       = c("white", "black", "gray"),
                  ref_col          = NULL,
                  pred_col         = NULL,
                  platform_col     = NULL,
                  show_ref         = TRUE,
                  show_predictions = TRUE,
                  show_platform    = TRUE,
                  show_scores      = TRUE,
                  show_rule_name   = TRUE,
                  legend           = TRUE,
                  cluster_cols     = TRUE,
                  cluster_rows     = TRUE,
                  anno_height      = 0.03,
                  score_height     = 0.03,
                  margin           = c(0, 5, 0, 5))
}
\arguments{
  \item{Data}{
    a matrix, dataframe, where samples as columns and row as features/genes. Can also take ExpressionSet, or data_object generated by ReadData function.
  }
  \item{classifier}{
    classifier as a rule_based_RandomForest object, generated by train_RF function
  }
  \item{ref}{
    Optional vector with the reference labels. Ref labels in data_object will be used if not ref input provided. For ExpressionSet, the name of the variable in the pheno data.
  }
  \item{prediction}{
    Optional. "ranger.prediction" object for the class scores generated by predict_RF function .
  }
  \item{platform}{
    Optional vector with the platform/study labels or any additional annotation. Platform labels in data_object will be used if no platform input provided. For ExpressionSet, the name of the variable in the pheno data.
  }
  \item{classes}{
    Optional vector with the class names. This will determine which classes will be plotted and in which order. It is not recommended to use both "classes" and "platforms_ord" arguments together.
  }
  \item{platforms_ord}{
    Optional vector with the platform/study names. This will determine which platform/study will be plotted and in which order. This will be used when top_anno="platform". It is not recommended to use both "classes" and "platforms_ord" arguments together.
  }
  \item{top_anno}{
    Determine the top annotation level. Samples will be grouped based on the top_anno. Input can be one of three options: "ref", "prediction", "platform". Default is "ref".
  }
  \item{title}{
    Carachter input as a title for the whole heatmap. Default is "".
  }
  \item{binary_col}{
    vector determines the colors of the binary heatmap. Default is c("white", "black", "gray"). First color for the color when the rule is false in the sample. Second color for the color when the rule is true. Third color is for NAs.
  }
  \item{ref_col}{
    optional named vector determines the colors of classes for the reference labels. Default is NULL. Vector names should match with the ref labels.
  }
  \item{pred_col}{
    optional named vector determines the colors of classes for the prediction labels. Default is NULL. Vector names should match with the prediction labels in the prediction labels.
  }
  \item{platform_col}{
    optional named vector determines the colors of platforms/study labels. Default is NULL. Vector names should match with the platforms/study labels.
  }
  \item{show_ref}{
    logical. Determines if the ref labels will be plotted or not. If the top_anno argument is "ref" then show_ref will be ignored.
  }
  \item{show_predictions}{
    logical. Determines if the prediction labels will be plotted or not. If the top_anno argument is "prediction" then show_predictions will be ignored.
  }
  \item{show_platform}{
    logical. Determines if the platform/study labels will be plotted or not. If the top_anno argument is "platform" then show_platform will be ignored.
  }
  \item{show_scores}{
    logical. Determines if the prediction scores will be plotted or not.
  }
  \item{show_rule_name}{
    logical. Determines if the rule names will be plotted on the left side of the heatmapp or not.
  }
  \item{legend}{
    logical. Determines if a legend will be plotted under the heatmap.
  }
  \item{cluster_cols}{
    logical. Clustering the samples in each class (i.e. not all samples in the cohort) based on the binary rules for that class. If top_anno is "platform" then the rules from all classes are used to cluster the samples in each platform.
  }
  \item{cluster_rows}{
    logical. Clustering the rules in each class.
  }
  \item{anno_height}{
    Determines the height of the annotations. It is recommended not to go out of this range 0.01<height<0.1. Default is 0.03.
  }
  \item{score_height}{
    Determines the height of the score bars. It is recommended not to go out of this range 0.01<height<0.1. Default is 0.03.
  }
  \item{margin}{
    Determines the margins of the heatmap. Default is c(0, 5, 0, 5).
  }
}

\value{
  returns a heatmap plot for the binary rule
}

\author{
  Nour-al-dain Marzouka <nour-al-dain.marzouka at med.lu.se>
}

\examples{
  # generate random data
Data <- matrix(runif(10000), nrow=100, ncol=80,
               dimnames = list(paste0("G",1:100), paste0("S",1:80)))

# generate random labels
L <- sample(x = c("A","B","C","D"), size = 80, replace = TRUE)

# generate random platform labels
P <- sample(c("P1","P2","P3"), size = 80, replace = TRUE)

# create data object
object <- ReadData(Data = Data,
                   Labels = L,
                   Platform = P,
                   verbose = FALSE)

# sort genes
genes_RF <- sort_genes_RF(data_object = object,
                           seed=123456, verbose = FALSE)

# creat and sort rules
rules_RF <- sort_rules_RF(data_object = object,
                           sorted_genes_RF = genes_RF,
                           genes_altogether = 10,
                           genes_one_vs_rest = 10,
                           seed=123456, verbose = FALSE)

# train the final model
# it is prefered to increase the number of trees and rules in case you have
# large number of samples and features
# for quick example, we have small number of trees and rules here
RF_classifier <- train_RF(data_object = object,
                          rules_altogether = 10,
                          rules_one_vs_rest = 10,
                          run_boruta = FALSE,
                          plot_boruta = FALSE,
                          num.trees = 300,
                          sorted_rules_RF = rules_RF,
                          verbose = FALSE)

# predict
results <- predict_RF(classifier = RF_classifier,
                       Data = object)

# not to run
# plot_binary_RF(Data = object,
#                classifier = RF_classifier,
#                prediction = results,
#                title = "Test")
}
