\name{predict_one_vs_rest_TSP}
\alias{predict_one_vs_rest_TSP}
\title{
Predict sample class based on one-vs-rest multiclass top score pairs classifier
}
\description{
\code{predict_one_vs_rest_TSP} predicts sample class based on one-vs-rest multiclass top score pairs classifier classifier
}
\usage{
predict_one_vs_rest_TSP(classifier,
                        Data,
                        tolerate_missed_genes = TRUE,
                        weighted_votes = TRUE,
                        classes,
                        verbose = TRUE)
}
\arguments{
  \item{classifier}{
  classifier as a OnevsrestScheme_TSP object, generated by train_one_vs_rest_TSP function

}
  \item{Data}{
a matrix, dataframe, ExpressionSet, or data_object generated by ReadData function.
Samples as columns and row as features/genes.
}
  \item{tolerate_missed_genes}{
  logical. TRUE means that if a gene in the classifier is missed in the data then this rule will be not considered in the prediction. If tolerate_missed_genes=TRUE then the user should keep an eye on the left rules. In some cases when the missed genes are too many then no enough rules left for a good prediction.
}
  \item{weighted_votes}{
logical indicates if the rules will be treated equally or be weighted by their scores. weighted_votes=TRUE is useful to break vote ties between classes.
}
  \item{classes}{
  optional vector with the names of the classes.
  This will be used to order the columns of the ouput dataframe. In case not all classes in the classifier is mentioned in the vector, then these classes will be excluded from the prediction.
}
 \item{verbose}{
a logical value indicating whether processing messages will be printed or not. Default is TRUE.
}

}

\value{
returns dataframe with classes votes, ties, and final prediction
}

\author{
Nour-al-dain Marzouka <nour-al-dain.marzouka at med.lu.se>
}

\examples{
# random data
Data <- matrix(runif(100000), nrow=100, ncol=100,
               dimnames = list(paste0("G",1:100), paste0("S",1:100)))

# labels
L <- sample(x = c("A","B","C"), size = 100, replace = TRUE)

# study/platform
P <- sample(c("P1","P2"), size = 100, replace = TRUE)

table(P,L)

object <- ReadData(Data = Data,
                   Labels = L,
                   Platform = P)

filtered_genes <- filter_genes_TSP(data_object = object,
                                  filter = "one_vs_rest",
                                  platform_wise = FALSE,
                                  featureNo = 10,
                                  UpDown = TRUE,
                                  verbose = FALSE)
filtered_genes

# training
classifier <- train_one_vs_rest_TSP(data_object = object,
                             filtered_genes = filtered_genes,
                             k_range = 2:50,
                             include_pivot = FALSE,
                             one_vs_one_scores = FALSE,
                             platform_wise_scores = FALSE,
                             seed = 1234,
                             verbose = FALSE)
classifier

results <- predict_one_vs_rest_TSP(classifier = classifier,
                                  Data = object,
                                  tolerate_missed_genes = TRUE,
                                  weighted_votes = TRUE,
                                  verbose = FALSE)
results
}
