% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.balance.R
\name{plot.covariate.balance}
\alias{plot.covariate.balance}
\title{Multiple covariate blance assessment plot.}
\usage{
\method{plot}{covariate.balance}(x, plot.strata = FALSE,
  order = c("unadjusted", "adjusted"), strata.size = 3,
  strata.legend.guide = "none", point.size = 3, point.alpha = 1,
  line.color = "black", line.alpha = 0.2, legend.position = c(0.8, 0.2),
  ...)
}
\arguments{
\item{x}{results of \code{\link{covariate.balance}}.}

\item{plot.strata}{whether individual strata should be plotted.}

\item{order}{how to order the y-axis. Possible values are adjusted,
unadjusted, or NULL (don't reorder).}

\item{strata.size}{text size for strata if plotted.}

\item{strata.legend.guide}{guide for legend placement for strata.}

\item{point.size}{size of the overall effect size points.}

\item{point.alpha}{transparency level of the overall effect size points.}

\item{line.color}{the color of the line connecting the overall effect size ponts.}

\item{line.alpha}{transparency level of the line connecting the overall effect size points.}

\item{legend.position}{where to position the legend.}

\item{...}{currently unused.}
}
\value{
a ggplot2 with an attribute, \code{effects}, that is the data frame
       used to create the plot.
}
\description{
A graphic based upon \code{\link{cv.bal.psa}} function in the \code{PSAgraphics}
package. This graphic plots the effect sizes for multiple covariated before and
after propensity score andjustement.
}

